/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.string;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weblogic.utils.enumerations.ArrayEnumerator;

public class Sprintf {
    private static Hashtable cache = new Hashtable();
    private Integer width;
    private boolean widthStar = false;
    private Integer precision;
    private boolean precisionStar = false;
    private char conversion;
    private String string_value = null;
    private boolean leftJustified;
    private boolean showSign;
    private boolean extraSpace;
    private boolean altForm;
    private boolean zeroPadding;

    public static String sprintf(String format, Object obj) {
        StringBuffer sb = new StringBuffer();
        Sprintf.sprintf(format, new Object[]{obj}, sb);
        return sb.toString();
    }

    public static String sprintf(String format, Object[] args) {
        StringBuffer sb = new StringBuffer();
        Sprintf.sprintf(format, args, sb);
        return sb.toString();
    }

    public static String sprintf(String format, Enumeration args) {
        StringBuffer sb = new StringBuffer();
        Sprintf.sprintf(format, args, sb);
        return sb.toString();
    }

    public static void sprintf(String format, Object obj, StringBuffer results) {
        Sprintf.sprintf(format, new Object[]{obj}, results);
    }

    public static void sprintf(String format, Object[] args, StringBuffer results) {
        Sprintf.sprintf(format, new ArrayEnumerator<Object>(args), results);
    }

    public static void sprintf(String format, Enumeration args, StringBuffer results) {
        Sprintf[] formats = (Sprintf[])cache.get(format);
        if (formats == null) {
            formats = Sprintf.parseFormatString(format);
            cache.put(format, formats);
        }
        boolean i = false;
        block12: for (int f = 0; f < formats.length; ++f) {
            Sprintf next = formats[f];
            if (next.string_value != null) {
                results.append(next.string_value);
                continue;
            }
            switch (next.numStars()) {
                case 0: {
                    break;
                }
                case 1: {
                    next.width = (Integer)args.nextElement();
                    break;
                }
                case 2: {
                    next.width = (Integer)args.nextElement();
                    next.precision = (Integer)args.nextElement();
                }
            }
            switch (next.conversion) {
                case 'd': 
                case 'i': {
                    next.format_d(args.nextElement(), results);
                    continue block12;
                }
                case 's': {
                    next.format_s(args.nextElement(), results);
                    continue block12;
                }
                case 'f': {
                    next.format_f(args.nextElement(), results);
                    continue block12;
                }
                case 'x': {
                    next.format_x(args.nextElement(), results, true);
                    continue block12;
                }
                case 'X': {
                    next.format_x(args.nextElement(), results, false);
                    continue block12;
                }
            }
        }
    }

    private Sprintf(String s) {
        this.string_value = s;
    }

    private Sprintf(String flags, String width_precision, char conversion) {
        this.conversion = conversion;
        this.leftJustified = flags.indexOf(45) != -1;
        this.showSign = flags.indexOf(43) != -1;
        this.extraSpace = flags.indexOf(32) != -1 && !this.showSign;
        this.altForm = flags.indexOf(35) != -1;
        boolean bl = this.zeroPadding = flags.indexOf(48) != -1;
        if (width_precision.length() > 0) {
            String precisionString;
            String widthString;
            int dot = width_precision.indexOf(".");
            if (dot == -1) {
                widthString = width_precision;
                precisionString = null;
            } else if (dot == 0) {
                widthString = null;
                precisionString = width_precision;
            } else if (dot == width_precision.length() - 1) {
                widthString = width_precision.substring(0, dot);
                precisionString = "0";
            } else {
                widthString = width_precision.substring(0, dot);
                precisionString = width_precision.substring(dot + 1);
            }
            if (widthString != null) {
                if (widthString.equals("*")) {
                    this.widthStar = true;
                } else {
                    this.width = new Integer(widthString);
                }
            }
            if (precisionString != null) {
                if (precisionString.equals("*")) {
                    this.precisionStar = true;
                } else {
                    this.precision = new Integer(precisionString);
                }
            }
        }
    }

    public int numStars() {
        int num = 0;
        if (this.widthStar) {
            ++num;
        }
        if (this.precisionStar) {
            ++num;
        }
        return num;
    }

    public static Sprintf[] parseFormatString(String string) {
        Vector<Sprintf> results = new Vector<Sprintf>();
        int i = 0;
        String current = "";
        block9: while (i < string.length()) {
            char c = string.charAt(i++);
            switch (c) {
                case '%': {
                    String flags = "";
                    String width_precision = "";
                    block10: while (i < string.length()) {
                        char c2 = string.charAt(i++);
                        switch (c2) {
                            case '%': {
                                current = current + "" + c2;
                                continue block9;
                            }
                            case '0': {
                                if (width_precision.equals("")) {
                                    flags = flags + "" + c2;
                                    continue block10;
                                }
                                width_precision = width_precision + "" + c2;
                                continue block10;
                            }
                            case ' ': 
                            case '#': 
                            case '+': 
                            case '-': {
                                flags = flags + "" + c2;
                                continue block10;
                            }
                            case 'E': 
                            case 'G': 
                            case 'X': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': 
                            case 'g': 
                            case 'i': 
                            case 'o': 
                            case 's': 
                            case 'u': 
                            case 'x': {
                                if (!current.equals("")) {
                                    results.addElement(new Sprintf(current));
                                    current = new String("");
                                }
                                results.addElement(new Sprintf(flags, width_precision, c2));
                                continue block9;
                            }
                        }
                        width_precision = width_precision + "" + c2;
                    }
                    continue block9;
                }
            }
            current = current + "" + c;
        }
        if (!current.equals("")) {
            results.addElement(new Sprintf(current));
        }
        Object[] formats = new Sprintf[results.size()];
        results.copyInto(formats);
        return formats;
    }

    private final void format_d(Object arg, StringBuffer sb) {
        block12: {
            char sign;
            Number i = (Number)arg;
            int start = sb.length();
            sb.append(i.toString());
            int w = Sprintf.getValue(this.width, 0);
            int p = Sprintf.getValue(this.precision, 1);
            int numLen = sb.length() - start;
            int pPadding = p - numLen;
            if (pPadding > 0) {
                for (int x = 0; x < pPadding; ++x) {
                    sb.insert(start, ' ');
                }
            }
            if (this.showSign) {
                sign = i.intValue() >= 0 ? (char)'+' : '-';
                sb.insert(start, sign);
            } else if (this.extraSpace) {
                sign = i.intValue() >= 0 ? (char)' ' : '-';
                sb.insert(start, sign);
            }
            int totalWidth = Math.max(w, p);
            if (totalWidth <= sb.length() - start) break block12;
            if (this.leftJustified) {
                for (int x = 0; x < totalWidth; ++x) {
                    sb.append(' ');
                }
            } else {
                int padLen = totalWidth - (sb.length() - start);
                if (this.zeroPadding && this.precision == null) {
                    int insertPoint = this.showSign || this.extraSpace ? start + 1 : start;
                    for (int x = 0; x < padLen; ++x) {
                        sb.insert(insertPoint, '0');
                    }
                } else {
                    for (int x = 0; x < padLen; ++x) {
                        sb.insert(start, ' ');
                    }
                }
            }
        }
    }

    private final void format_s(Object arg, StringBuffer sb) {
        int start = sb.length();
        sb.append(arg.toString());
        int p = Sprintf.getValue(this.precision, sb.length() - start);
        int w = Sprintf.getValue(this.width, 0);
        int padding = w - p;
        sb.setLength(p + start);
        if (this.leftJustified) {
            for (int i = 0; i < padding; ++i) {
                sb.append(' ');
            }
        } else {
            for (int i = 0; i < padding; ++i) {
                sb.insert(start, ' ');
            }
        }
    }

    private final void format_f(Object arg, StringBuffer sb) {
        block10: {
            char sign;
            int start = sb.length();
            Number d = (Number)arg;
            int p = Sprintf.getValue(this.precision, 6);
            int w = Sprintf.getValue(this.width, 0);
            sb.append(Sprintf.adjDoublePrecision(d, p));
            int numLen = sb.length() - start;
            int pPadding = p - numLen;
            if (this.showSign) {
                sign = d.doubleValue() >= 0.0 ? (char)'+' : '-';
                sb.insert(start, sign);
            } else if (this.extraSpace) {
                sign = d.doubleValue() >= 0.0 ? (char)' ' : '-';
                sb.insert(start, sign);
            }
            int totalWidth = w;
            if (totalWidth <= sb.length() - start) break block10;
            if (this.leftJustified) {
                for (int x = 0; x < totalWidth; ++x) {
                    sb.append(' ');
                }
            } else {
                int padLen = totalWidth - (sb.length() - start);
                if (this.zeroPadding) {
                    int insertPoint = this.showSign || this.extraSpace ? start + 1 : start;
                    for (int x = 0; x < padLen; ++x) {
                        sb.insert(insertPoint, '0');
                    }
                } else {
                    for (int x = 0; x < padLen; ++x) {
                        sb.insert(start, ' ');
                    }
                }
            }
        }
    }

    private final void format_x(Object arg, StringBuffer sb, boolean lower) {
        block11: {
            int totalWidth;
            int start = sb.length();
            int val = (Integer)arg;
            if (lower) {
                sb.append(Integer.toHexString(val));
            } else {
                sb.append(Integer.toHexString(val).toUpperCase());
            }
            int w = Sprintf.getValue(this.width, 0);
            int p = Sprintf.getValue(this.precision, 1);
            int numLen = sb.length() - start;
            int pPadding = p - numLen;
            if (pPadding > 0) {
                for (int x = 0; x < pPadding; ++x) {
                    sb.insert(start, '0');
                }
            }
            if ((totalWidth = Math.max(w, p)) <= sb.length() - start) break block11;
            if (this.leftJustified) {
                for (int x = 0; x < totalWidth; ++x) {
                    sb.append(' ');
                }
            } else {
                int padLen = totalWidth - (sb.length() - start);
                if (this.zeroPadding && this.precision == null) {
                    int insertPoint = this.showSign || this.extraSpace ? start + 1 : start;
                    for (int x = 0; x < padLen; ++x) {
                        sb.insert(insertPoint, '0');
                    }
                } else {
                    for (int x = 0; x < padLen; ++x) {
                        sb.insert(start, ' ');
                    }
                }
            }
        }
    }

    private static int getValue(Integer i, int def) {
        if (i == null) {
            return def;
        }
        return i;
    }

    private static StringBuffer adjDoublePrecision(Number d, int prec) {
        String decimalPart;
        String wholePart;
        String str = d.toString();
        int dot = str.indexOf(46);
        if (dot == -1) {
            wholePart = str;
            decimalPart = "0";
        } else {
            wholePart = str.substring(0, dot);
            decimalPart = str.substring(dot + 1);
        }
        int decLen = decimalPart.length();
        if (decLen < prec) {
            StringBuffer res = new StringBuffer(wholePart + "." + decimalPart);
            for (int i = decLen; i < prec; ++i) {
                res.append('0');
            }
            return res;
        }
        if (decLen > prec) {
            double rounded = Double.valueOf(wholePart + "." + decimalPart);
            rounded *= Math.pow(10.0, prec);
            rounded = Math.rint(rounded);
            return Sprintf.adjDoublePrecision(new Double(rounded /= Math.pow(10.0, prec)), prec);
        }
        return new StringBuffer(str);
    }
}

