/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.time;

import weblogic.utils.time.JavaTimer;

public abstract class Timer {
    private long startTime;
    private long pausedTime;
    private long pausedElapsed;

    public void start() {
        if (this.startTime != 0L) {
            throw new IllegalStateException("Timer already started");
        }
        this.startTime = this.timestamp();
    }

    public void pause() {
        if (this.startTime == 0L) {
            throw new IllegalStateException("Timer not running");
        }
        this.pausedTime = this.timestamp();
    }

    public void resume() {
        if (this.pausedTime == 0L) {
            throw new IllegalStateException("Timer not paused");
        }
        this.pausedElapsed += this.timestamp() - this.pausedTime;
        this.pausedTime = 0L;
    }

    public long stop() {
        if (this.startTime == 0L) {
            throw new IllegalStateException("Timer not started");
        }
        long ret = this.timestamp() - this.startTime - this.pausedElapsed;
        this.startTime = 0L;
        this.pausedElapsed = 0L;
        return ret;
    }

    public static Timer createTimer() {
        try {
            return (Timer)TimerFactory.FACTORY.newInstance();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public abstract boolean isNative();

    public abstract long timestamp();

    public static void main(String[] args) {
        Timer timer = Timer.createTimer();
        String timerType = timer.isNative() ? "Native" : "Java";
        System.err.println("Created " + timerType + " Timer: " + timer);
        timer.start();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
        }
        long timerElapsed = timer.stop();
        System.out.println("Timer ticks / sec: " + timerElapsed);
    }

    private static final class TimerFactory {
        private static final Class FACTORY = TimerFactory.getFactory();

        private TimerFactory() {
        }

        private static final Class getFactory() {
            try {
                Class.forName("java.lang.management.ThreadInfo");
                return Class.forName("weblogic.utils.time.JDK15NanoTimer");
            }
            catch (Exception e) {
                return JavaTimer.class;
            }
        }
    }
}

