/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.zip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weblogic.utils.zip.NullZipEntry;
import weblogic.utils.zip.SafeZipFileInputStream;

class ZipURLConnection
extends URLConnection {
    static final ZipEntry NULL_ZIP_ENTRY = new NullZipEntry();
    static final String UNC_PREFIX;
    private ZipFile zip;
    private ZipEntry ze;

    public ZipURLConnection(URL u) {
        super(u);
    }

    @Override
    public String getContentType() {
        return ZipURLConnection.getFileNameMap().getContentTypeFor(this.url.getPath());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new SafeZipFileInputStream(this.zip, this.ze);
    }

    @Override
    public long getLastModified() {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.ze.getTime();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    @Override
    public long getContentLengthLong() {
        try {
            if (!this.connected) {
                this.connect();
            }
            if (this.ze != null) {
                return this.ze.getSize();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public void connect() throws IOException {
        String file = URLDecoder.decode(this.url.getFile().replaceAll("[+]", "%2B"), "UTF-8");
        int excl = file.indexOf("!/");
        String zipFile = (excl != -1 ? file.substring(0, excl) : file).replace('/', File.separatorChar);
        String host = this.url.getHost();
        if (host != null && !host.equals("") && !host.equalsIgnoreCase("localhost")) {
            zipFile = UNC_PREFIX + host + zipFile;
        }
        this.zip = new ZipFile(zipFile);
        ZipEntry zipEntry = excl != -1 ? this.zip.getEntry(file.substring(excl + 2, file.length())) : (this.ze = file.endsWith(".jar") ? NULL_ZIP_ENTRY : null);
        if (this.ze == null) {
            throw new FileNotFoundException(this.url.toString());
        }
        this.connected = true;
    }

    static {
        String name = "unknown";
        try {
            name = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        UNC_PREFIX = name.startsWith("windows") ? "\\\\" : "//";
    }
}

