/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.collections.MaybeMapper;
import weblogic.work.PriorityRequestQueue;
import weblogic.work.RequestClass;
import weblogic.work.RequestManager;
import weblogic.work.SelfTuningWorkManagerImpl;

public class CalendarQueue<T>
implements PriorityRequestQueue<T> {
    private static final DebugCategory debug = Debug.getCategory("weblogic.CalendarQueue");
    private int[] calendar = new int[2048];
    private int size;
    private long now;
    private int freeList = 0;
    private int[] next;
    private int[] last;
    private long[] time;
    private T[] data;
    private long[] mt;
    private long busyPeriodStart;
    private final int initialCapacity;
    private final boolean allowShrinking;
    private volatile boolean empty = true;
    private long queueEmptiedCounter;
    private MaybeMapper<T> expiredElementMapper;
    private RequestManager.Callable<T, T> OR_ELSE = new RequestManager.Callable<T, T>(){

        @Override
        public T call(T closure) {
            return closure;
        }
    };

    CalendarQueue(boolean allowShrinking, MaybeMapper<T> expiredElementMapper) {
        this(400, allowShrinking, expiredElementMapper);
    }

    CalendarQueue(int capacity, boolean allowShrinking, MaybeMapper<T> expiredElementMapper) {
        this.initialCapacity = capacity;
        this.allowShrinking = allowShrinking;
        this.expiredElementMapper = expiredElementMapper;
        this.init(capacity);
    }

    private void init(int capacity) {
        this.next = new int[capacity];
        this.last = new int[capacity];
        this.time = new long[capacity];
        this.data = new Object[capacity];
        this.mt = new long[capacity];
    }

    private void shrink() {
        if (this.allowShrinking && this.arraySize() > this.initialCapacity) {
            assert (this.verifyEmptyCalendarQueue()) : "shrink() does not expect non-empty calendar[]";
            this.init(this.initialCapacity);
            this.freeList = 0;
        }
    }

    private boolean verifyEmptyCalendarQueue() {
        int arrayLen = this.calendar.length;
        for (int i = 0; i < arrayLen; ++i) {
            if (this.calendar[i] == 0) continue;
            return false;
        }
        return true;
    }

    int arraySize() {
        return this.next.length;
    }

    private void resetVirtualTime() {
        this.now = 0L;
    }

    @Override
    public synchronized <X, V> V add(T o, long maybeToken, RequestClass p, RequestManager.Callable<X, V> andThen, X closure) {
        if (this.size == 0) {
            this.busyPeriodStart = System.currentTimeMillis();
            this.empty = false;
        }
        long t = this.now + p.getVirtualTimeIncrement(this.now, this.queueEmptiedCounter);
        int n = this.allocNode();
        this.data[n] = o;
        this.mt[n] = maybeToken;
        this.time[n] = t;
        int i = t <= (this.now | 0xFFL) ? (int)t & 0xFF : (t <= (this.now | 0xFFFFL) ? 256 + ((int)(t >>> 8) & 0xFF) : (t <= (this.now | 0xFFFFFFL) ? 512 + ((int)(t >>> 16) & 0xFF) : (t <= (this.now | 0xFFFFFFFFL) ? 768 + ((int)(t >>> 24) & 0xFF) : (t <= (this.now | 0xFFFFFFFFFFL) ? 1024 + ((int)(t >>> 32) & 0xFF) : (t <= (this.now | 0xFFFFFFFFFFFFL) ? 1280 + ((int)(t >>> 40) & 0xFF) : (t <= (this.now | 0xFFFFFFFFFFFFFFL) ? 1536 + ((int)(t >>> 48) & 0xFF) : 1792 + ((int)(t >>> 56) & 0xFF)))))));
        this.add(i, n);
        return andThen.call(closure);
    }

    private void add(int index, int node) {
        int c = this.calendar[index];
        if (c == 0) {
            this.calendar[index] = node;
            this.last[node] = node;
        } else {
            this.next[this.last[c]] = node;
            this.last[c] = node;
        }
    }

    private int allocNode() {
        int s = ++this.size;
        int f = this.freeList;
        if (f != 0) {
            this.freeList = this.next[f];
            return f;
        }
        if (s == this.next.length) {
            int removed;
            if (this.allowShrinking && (removed = this.removeExpiredElements()) > this.next.length / 2) {
                if (CalendarQueue.debugEnabled()) {
                    CalendarQueue.debug("no need to grow");
                }
                f = this.freeList;
                assert (f != 0) : "freeList after gc() should not be empty!";
                this.freeList = this.next[f];
                return f;
            }
            this.grow();
            if (CalendarQueue.debugEnabled()) {
                CalendarQueue.debug("grow() called. Arrays are of length " + this.next.length);
            }
        }
        return s;
    }

    @Deprecated
    public synchronized T pop(T suggestion, RequestClass rci) {
        if (suggestion != null) {
            return suggestion;
        }
        return this.pop(null, this.OR_ELSE, null);
    }

    @Override
    @Deprecated
    public synchronized T pop() {
        return this.pop(null, this.OR_ELSE, null);
    }

    @Override
    public synchronized <V> T pop(MaybeMapper<T> mu, RequestManager.Callable<V, T> orElse, V closure) {
        T result;
        RuntimeException unboxException = null;
        do {
            int c;
            if (this.size == 0) {
                this.empty = true;
                if (this.busyPeriodStart > 0L) {
                    this.busyPeriodStart = 0L;
                    this.resetVirtualTime();
                    this.shrink();
                    ++this.queueEmptiedCounter;
                }
                return orElse.call(closure);
            }
            --this.size;
            int m = 1;
            int i = (int)this.now & 0xFF;
            while (this.calendar[i] == 0) {
                if ((++i & 0xFF) != 0) continue;
                i = 256 * m + ((int)(this.now >>> 8 * m) & 0xFF);
                ++m;
            }
            if (i >= 256) {
                if (i >= 512) {
                    if (i >= 768) {
                        if (i >= 1024) {
                            if (i >= 1280) {
                                if (i >= 1536) {
                                    if (i >= 1792) {
                                        i = this.promote(1536, 48, i);
                                    }
                                    i = this.promote(1280, 40, i);
                                }
                                i = this.promote(1024, 32, i);
                            }
                            i = this.promote(768, 24, i);
                        }
                        i = this.promote(512, 16, i);
                    }
                    i = this.promote(256, 8, i);
                }
                c = this.calendar[i];
                this.calendar[i] = 0;
                int l = this.last[c];
                int minI = i = (int)this.time[c] & 0xFF;
                this.last[c] = c;
                this.calendar[i] = c;
                while (c != l) {
                    c = this.next[c];
                    i = (int)this.time[c] & 0xFF;
                    this.add(i, c);
                    if (i >= minI) continue;
                    minI = i;
                }
                i = minI;
            }
            if (this.last[c = this.calendar[i]] == c) {
                this.calendar[i] = 0;
            } else {
                int n;
                this.calendar[i] = n = this.next[c];
                this.last[n] = this.last[c];
            }
            this.next[c] = this.freeList;
            this.freeList = c;
            this.now = this.time[c];
            result = this.data[c];
            this.data[c] = null;
            long maybeToken = this.mt[c];
            if (mu == null) continue;
            try {
                result = mu.unbox(result, maybeToken);
            }
            catch (RuntimeException t) {
                unboxException = t;
                break;
            }
        } while (result == null);
        if (unboxException != null) {
            if (orElse != null) {
                orElse.call(closure);
            }
            throw unboxException;
        }
        return result;
    }

    private int promote(int off, int shift, int i) {
        int c = this.calendar[i];
        this.calendar[i] = 0;
        int l = this.last[c];
        int minI = i = off + ((int)(this.time[c] >>> shift) & 0xFF);
        this.last[c] = c;
        this.calendar[i] = c;
        while (c != l) {
            c = this.next[c];
            i = off + ((int)(this.time[c] >>> shift) & 0xFF);
            this.add(i, c);
            if (i >= minI) continue;
            minI = i;
        }
        return minI;
    }

    private void grow() {
        int n = 2 * this.next.length;
        this.next = this.copy(this.next, new int[n]);
        this.last = this.copy(this.last, new int[n]);
        this.time = this.copy(this.time, new long[n]);
        this.data = this.copy(this.data, new Object[n]);
        this.mt = this.copy(this.mt, new long[n]);
    }

    private int removeExpiredElements() {
        if (this.expiredElementMapper == null) {
            return 0;
        }
        int removed = 0;
        for (int i = 0; i < this.calendar.length; ++i) {
            if (this.calendar[i] <= 0) continue;
            int node = this.calendar[i];
            int lastNode = this.last[node];
            int prev = 0;
            while (node > 0) {
                int nextNode = this.next[node];
                T value = this.data[node];
                if (this.expiredElementMapper.unbox(value, this.mt[node]) == null) {
                    prev = node;
                } else {
                    this.data[node] = null;
                    if (prev == 0) {
                        if (node == lastNode) {
                            this.calendar[i] = 0;
                        } else {
                            this.calendar[i] = this.next[node];
                            this.last[this.next[node]] = this.last[node];
                        }
                    } else if (node == lastNode) {
                        this.last[this.calendar[i]] = prev;
                        this.next[prev] = 0;
                    } else {
                        this.next[prev] = this.next[node];
                    }
                    this.next[node] = this.freeList;
                    this.freeList = node;
                    ++removed;
                }
                if (node == lastNode) {
                    node = 0;
                    continue;
                }
                node = nextNode;
            }
        }
        if (debug.isEnabled()) {
            CalendarQueue.debug("removeExpiredElements() removed " + removed + " entries");
        }
        this.size -= removed;
        return removed;
    }

    private int[] copy(int[] src, int[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    private long[] copy(long[] src, long[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    private T[] copy(T[] src, T[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public long getMaxValue() {
        return Long.MAX_VALUE;
    }

    private void dump() {
        for (int i = 0; i < this.calendar.length; i += 256) {
            this.dumpPeriod(i);
        }
    }

    private void dumpPeriod(int low) {
        int high = low + 256;
        StringBuilder s = new StringBuilder("{");
        String sep = "";
        block0: for (int i = low; i < high; ++i) {
            int c = this.calendar[i];
            if (c == 0) continue;
            int l = this.last[c];
            while (true) {
                s.append(sep);
                s.append(this.data[c]);
                s.append("(");
                s.append(this.mt[c]);
                s.append(")@");
                s.append(Long.toHexString(this.time[c]));
                sep = ", ";
                if (c == l) continue block0;
                c = this.next[c];
            }
        }
        System.out.println(s.append("}").toString());
    }

    private static boolean debugEnabled() {
        return debug.isEnabled() || SelfTuningWorkManagerImpl.debugEnabled();
    }

    private static void debug(String str) {
        SelfTuningWorkManagerImpl.debug("<CalendarQueue>" + str);
    }
}

