/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import javax.management.InvalidAttributeValueException;
import weblogic.kernel.ExecuteQueueMBeanStub;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.work.KernelDelegator;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class ExecuteQueueFactory
extends WorkManagerFactory {
    private static ExecuteQueueFactory SINGLETON;

    private ExecuteQueueFactory() {
    }

    public static synchronized void initialize(KernelMBean kmb) {
        if (SINGLETON != null) {
            return;
        }
        SINGLETON = new ExecuteQueueFactory();
        WorkManagerFactory.set(SINGLETON);
        SINGLETON.initializeHere(kmb);
    }

    private void initializeHere(KernelMBean kmb) {
        if (kmb != null) {
            ExecuteQueueMBean[] queueBeans = kmb.getExecuteQueues();
            int i = queueBeans.length;
            while (--i >= 0) {
                ExecuteQueueMBean queueBean = queueBeans[i];
                String name = queueBean.getName();
                if (name.startsWith("wl_bootstrap_")) {
                    name = name.substring(13);
                }
                this.create(name, queueBean);
            }
        }
        if (this.DEFAULT == null) {
            ExecuteQueueMBeanStub queueBean = new ExecuteQueueMBeanStub();
            if (kmb != null && kmb.getThreadPoolSize() > 0) {
                try {
                    queueBean.setThreadCount(kmb.getThreadPoolSize());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.create(queueBean.getName(), queueBean);
        }
        if (Kernel.isServer()) {
            KernelDelegator nonBlocking = new KernelDelegator("weblogic.kernel.Non-Blocking", 3);
            this.byName.put("weblogic.kernel.Non-Blocking", nonBlocking);
            this.SYSTEM = new KernelDelegator("weblogic.kernel.System", kmb.getSystemThreadPoolSize());
            this.byName.put("weblogic.kernel.System", this.SYSTEM);
            this.REJECTOR = new KernelDelegator("weblogic.Rejector", 2);
        } else {
            this.SYSTEM = this.DEFAULT;
        }
        KernelDelegator direct = new KernelDelegator();
        this.byName.put("direct", direct);
    }

    @Override
    protected WorkManager create(String name, int priority, int maxThreads, int minThreads) {
        return this.create(name, maxThreads, minThreads);
    }

    private WorkManager create(String name, int maxThreads, int minThreads) {
        int threadCount = Math.max(minThreads, maxThreads);
        return new KernelDelegator(name, threadCount);
    }

    private WorkManager create(String name, ExecuteQueueMBean eqmb) {
        KernelDelegator manager = new KernelDelegator(name, eqmb);
        if ("weblogic.kernel.Default".equalsIgnoreCase(name) || "default".equalsIgnoreCase(name)) {
            this.DEFAULT = manager;
        } else {
            this.byName.put(name, manager);
        }
        return manager;
    }

    public static WorkManager createExecuteQueue(String name, int noOfThreads) {
        ExecuteQueueMBeanStub queueBean = new ExecuteQueueMBeanStub();
        try {
            queueBean.setThreadCount(noOfThreads);
            queueBean.setThreadsIncrease(0);
            queueBean.setThreadsMaximum(noOfThreads);
        }
        catch (InvalidAttributeValueException iave) {
            throw new AssertionError((Object)("Invalid ExecuteQueueMBean attributes specified for " + name));
        }
        assert (SINGLETON != null);
        return SINGLETON.create(name, queueBean);
    }
}

