/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import weblogic.kernel.AuditableThread;
import weblogic.kernel.KernelStatus;
import weblogic.work.WorkManagerLite;

public class ExecuteThreadLite
extends AuditableThread {
    private WorkManagerLite wm;
    private int hashcode;
    private Runnable runnable;
    private boolean started;

    ExecuteThreadLite(int which, WorkManagerLite wm, ThreadGroup tg) {
        super(tg, "ExecuteThread: '" + which + "' for queue: '" + wm.getName() + "'");
        this.init(wm);
    }

    protected void init(WorkManagerLite wm) {
        this.wm = wm;
        this.hashcode = this.getName().hashCode();
        this.setDaemon(true);
    }

    public int hashCode() {
        return this.hashcode;
    }

    synchronized void notifyRequest(Runnable runnable) {
        this.runnable = runnable;
        this.notify();
    }

    void setRequest(Runnable runnable) {
        this.runnable = runnable;
    }

    private synchronized void waitForRequest() {
        while (this.runnable == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ExecuteThreadLite executeThreadLite = this;
        synchronized (executeThreadLite) {
            this.started = true;
            this.readyToRun();
            this.notify();
        }
        while (true) {
            try {
                while (true) {
                    if (this.runnable != null) {
                        this.execute(this.runnable);
                    }
                    this.reset();
                    this.wm.registerIdle(this);
                    if (this.runnable != null) continue;
                    this.waitForRequest();
                }
            }
            catch (ThreadDeath td) {
                if (!KernelStatus.isServer()) continue;
                throw td;
            }
            break;
        }
    }

    void execute(Runnable work) {
        try {
            work.run();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    protected final void reset() {
        super.reset();
        this.runnable = null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public WorkManagerLite getWorkManager() {
        return this.wm;
    }
}

