/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import weblogic.utils.concurrent.WaterMark;
import weblogic.work.PartitionFairShare;
import weblogic.work.RequestClass;

public class OverloadManager {
    static final String SHARED_OVERLOAD_MANAGER_NAME = "global overload manager";
    static final String PARTITION_OVERLOAD_MANAGER_NAME = "partition overload manager";
    private AtomicInteger queueDepth = new AtomicInteger();
    private AtomicInteger rejectedRequestsCount = null;
    private String name;
    private final boolean isSharedOverloadManager;
    private String partitionName;
    private WaterMark capacity;
    private int percentage;
    private int nearCapacityThreshold;
    private HashSet activeRequestClassNamesInOverload;
    private static final List<OverloadManager> partitionOverloadManagers = new ArrayList<OverloadManager>();
    static final float NEAR_CAPACITY_THRESHOLD = 0.1f;
    final OverloadManager parent;

    OverloadManager(String name) {
        this(name, 0);
    }

    public OverloadManager(String name, int count) {
        if (count < 0) {
            count = 0;
        }
        this.name = name;
        this.capacity = new WaterMark(count);
        this.isSharedOverloadManager = SHARED_OVERLOAD_MANAGER_NAME.equals(name);
        this.nearCapacityThreshold = (int)(0.1f * (float)count);
        this.parent = null;
    }

    private OverloadManager(String partitionName, OverloadManager parent, int percentage) {
        this.name = "partition overload manager$" + partitionName;
        this.isSharedOverloadManager = false;
        this.partitionName = partitionName;
        this.percentage = percentage;
        this.parent = parent;
        this.capacity = new WaterMark(this.calculateCapacity());
        if (parent.isRejectedRequestsCounterEnabled()) {
            this.enableRejectedRequestsCounter();
        }
    }

    void setPercentage(int percentage) {
        if (this.parent == null) {
            return;
        }
        if (this.percentage == percentage) {
            return;
        }
        this.percentage = percentage;
        this.setCapacity(this.calculateCapacity());
    }

    private int calculateCapacity() {
        if (this.percentage == 0) {
            return 0;
        }
        int baseCount = this.parent.getCapacity();
        int capacity = baseCount * this.percentage / 100;
        return capacity < 1 ? 1 : capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OverloadManager createPartitionOverloadManager(String partitionName, OverloadManager parent, int percentage) {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        OverloadManager overloadManager = new OverloadManager(partitionName, parent, percentage);
        List<OverloadManager> list = partitionOverloadManagers;
        synchronized (list) {
            partitionOverloadManagers.add(overloadManager);
        }
        return overloadManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<OverloadManager> getListOfNearCapacityPartitionOverloadManager() {
        ArrayList<OverloadManager> list = null;
        List<OverloadManager> list2 = partitionOverloadManagers;
        synchronized (list2) {
            for (OverloadManager overloadManager : partitionOverloadManagers) {
                if (overloadManager.nearCapacity()) {
                    if (list == null) {
                        list = new ArrayList<OverloadManager>();
                    }
                    list.add(overloadManager);
                    continue;
                }
                overloadManager.resetActiveRequestClassesInOverload();
            }
        }
        return list;
    }

    void enableRejectedRequestsCounter() {
        if (this.rejectedRequestsCount == null) {
            this.rejectedRequestsCount = new AtomicInteger();
        }
    }

    boolean isRejectedRequestsCounterEnabled() {
        return this.rejectedRequestsCount != null;
    }

    public final int getCapacity() {
        return this.capacity.getOriginalLevel();
    }

    public final void setCapacity(int count) {
        if (count < 0) {
            count = 0;
        }
        this.capacity.resetLevel(count);
        if (this.isSharedOverloadManager) {
            OverloadManager.updatePartitionOverloadManagersCapacity();
        }
        this.nearCapacityThreshold = (int)(0.1f * (float)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updatePartitionOverloadManagersCapacity() {
        List<OverloadManager> list = partitionOverloadManagers;
        synchronized (list) {
            for (OverloadManager overloadManager : partitionOverloadManagers) {
                overloadManager.setCapacity(overloadManager.calculateCapacity());
            }
        }
    }

    boolean canAcceptMore() {
        return !this.capacity.isEnabled() || this.capacity.getCurrentLevel() > 0;
    }

    boolean nearCapacity() {
        return this.capacity.isEnabled() && this.capacity.getCurrentLevel() <= this.nearCapacityThreshold;
    }

    public String getName() {
        return this.name;
    }

    public int getInProgress() {
        return this.capacity.diff();
    }

    int getQueueDepth() {
        return this.queueDepth.get();
    }

    void acceptWork() {
        this.capacity.decreaseLevel(1);
    }

    void finishWork() {
        this.capacity.increaseLevel(1);
    }

    void incrementQueueDepth() {
        this.queueDepth.getAndIncrement();
    }

    void decrementQueueDepth() {
        this.queueDepth.getAndDecrement();
    }

    void incrementRejectedRequestsCounter() {
        if (this.rejectedRequestsCount != null) {
            this.rejectedRequestsCount.getAndIncrement();
        }
    }

    public int getRejectedRequestsCount() {
        if (this.rejectedRequestsCount != null) {
            return this.rejectedRequestsCount.get();
        }
        return 0;
    }

    void activeRequestClassNamesInOverload(List sortedRequestClasses) {
        if (this.activeRequestClassNamesInOverload == null) {
            this.activeRequestClassNamesInOverload = new HashSet();
        }
        this.activeRequestClassNamesInOverload.clear();
        int count = 0;
        int myCapacity = this.getCapacity();
        for (RequestClass requestClass : sortedRequestClasses) {
            if (requestClass == null || !this.isRequestClassForSamePartition(requestClass)) continue;
            if ((count += requestClass.getPendingRequestsCount()) >= myCapacity) {
                return;
            }
            this.activeRequestClassNamesInOverload.add(requestClass.getName());
        }
    }

    boolean isRequestClassForSamePartition(RequestClass requestClass) {
        if (this.partitionName == null) {
            return true;
        }
        PartitionFairShare partitionFairShare = requestClass.getPartitionFairShare();
        if (partitionFairShare != null) {
            return this.partitionName.equals(partitionFairShare.getName());
        }
        return false;
    }

    boolean acceptRequestClass(RequestClass rc) {
        return this.activeRequestClassNamesInOverload != null && this.activeRequestClassNamesInOverload.contains(rc.getName());
    }

    void resetActiveRequestClassesInOverload() {
        if (this.activeRequestClassNamesInOverload != null && this.activeRequestClassNamesInOverload.size() > 0) {
            this.activeRequestClassNamesInOverload.clear();
        }
    }

    HashSet getActiveRequestClassNamesInOverload() {
        return this.activeRequestClassNamesInOverload;
    }

    static void reset() {
        partitionOverloadManagers.clear();
    }

    static List<OverloadManager> getPartitionOverloadManagers() {
        return partitionOverloadManagers;
    }
}

