/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;

public abstract class PartitionUtility {
    private static final PartitionUtility DEFAULT_PARTITION_UTILITY;
    private static PartitionUtility instance;
    static final int NUM_SLOWDOWN_LEVELS = 10;

    static void setInstance(PartitionUtility partitionUtility) {
        instance = partitionUtility;
    }

    public static ComponentInvocationContext getCurrentComponentInvocationContext() {
        return instance.doGetCurrentComponentInvocationContext();
    }

    public static String getCurrentPartitionId() {
        return instance.doGetCurrentPartitionId();
    }

    public static String getCurrentPartitionName(boolean returnNullForGlobal) {
        return instance.doGetCurrentPartitionName(returnNullForGlobal);
    }

    public static void runWorkUnderContext(Runnable work, ComponentInvocationContext context) throws ExecutionException {
        instance.doRunWorkUnderContext(work, context);
    }

    public static <T> T runWorkUnderContext(Callable<T> work, ComponentInvocationContext context) throws ExecutionException {
        return instance.doRunWorkUnderContext(work, context);
    }

    public static <T> T runWorkUnderGlobalContext(Callable<T> work) throws ExecutionException {
        return instance.doRunWorkUnderGlobalContext(work);
    }

    public static ComponentInvocationContext createComponentInvocationContext(String partitionName, String applicationName, String applicationVersion, String moduleName, String componentName) {
        return instance.doCreateComponentInvocationContext(partitionName, applicationName, applicationVersion, moduleName, componentName);
    }

    public abstract ComponentInvocationContext doGetCurrentComponentInvocationContext();

    public abstract String doGetCurrentPartitionId();

    public abstract String doGetCurrentPartitionName(boolean var1);

    public abstract void doRunWorkUnderContext(Runnable var1, ComponentInvocationContext var2) throws ExecutionException;

    public abstract <T> T doRunWorkUnderContext(Callable<T> var1, ComponentInvocationContext var2) throws ExecutionException;

    public abstract <T> T doRunWorkUnderGlobalContext(Callable<T> var1) throws ExecutionException;

    public abstract ComponentInvocationContext doCreateComponentInvocationContext(String var1, String var2, String var3, String var4, String var5);

    static {
        instance = DEFAULT_PARTITION_UTILITY = new FixedContextPartitionUtility();
    }

    private static class FixedContextPartitionUtility
    extends PartitionUtility {
        private FixedContextPartitionUtility() {
        }

        @Override
        public ComponentInvocationContext doGetCurrentComponentInvocationContext() {
            return ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext();
        }

        @Override
        public String doGetCurrentPartitionId() {
            ComponentInvocationContext componentInvocationContext = this.doGetCurrentComponentInvocationContext();
            if (componentInvocationContext != null) {
                return componentInvocationContext.getPartitionId();
            }
            return null;
        }

        @Override
        public String doGetCurrentPartitionName(boolean returnNullForGlobal) {
            ComponentInvocationContext componentInvocationContext = this.doGetCurrentComponentInvocationContext();
            if (componentInvocationContext != null) {
                if (returnNullForGlobal && componentInvocationContext.isGlobalRuntime()) {
                    return null;
                }
                return componentInvocationContext.getPartitionName();
            }
            return null;
        }

        @Override
        public void doRunWorkUnderContext(Runnable work, ComponentInvocationContext context) throws ExecutionException {
            this.checkSameContext(context);
            try {
                work.run();
            }
            catch (RuntimeException e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public <T> T doRunWorkUnderContext(Callable<T> work, ComponentInvocationContext context) throws ExecutionException {
            this.checkSameContext(context);
            try {
                return work.call();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public <T> T doRunWorkUnderGlobalContext(Callable<T> work) throws ExecutionException {
            this.checkGlobalContext();
            try {
                return work.call();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public ComponentInvocationContext doCreateComponentInvocationContext(String partitionName, String applicationName, String applicationVersion, String moduleName, String componentName) {
            return ComponentInvocationContextManager.getInstance().createComponentInvocationContext(partitionName, applicationName, applicationVersion, moduleName, componentName);
        }

        void checkSameContext(ComponentInvocationContext cic) throws ExecutionException {
            ComponentInvocationContext currentCIC = this.doGetCurrentComponentInvocationContext();
            if (cic != null && !cic.equals(currentCIC)) {
                throw new ExecutionException(new SecurityException("Not authorized to task under a different ComponentInvocationContext "));
            }
        }

        void checkGlobalContext() throws ExecutionException {
            ComponentInvocationContext currentCIC = this.doGetCurrentComponentInvocationContext();
            if (!currentCIC.isGlobalRuntime()) {
                throw new ExecutionException(new SecurityException("Not authorized to run task under the global domain"));
            }
        }
    }
}

