/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.kernel.KernelStatus;
import weblogic.kernel.T3SrvrLogger;
import weblogic.utils.collections.MaybeMapper;
import weblogic.utils.collections.PartialOrderSet;
import weblogic.work.CalendarQueue;
import weblogic.work.ConcurrentCalendarQueue;
import weblogic.work.ConstraintFullQueueException;
import weblogic.work.ExecuteThread;
import weblogic.work.IncrementAdvisor;
import weblogic.work.IncrementAdvisor2;
import weblogic.work.IncrementAdvisorIntf;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.MinThreadsConstraint;
import weblogic.work.OverloadManager;
import weblogic.work.PartitionAffinityThreadPool;
import weblogic.work.PartitionFairShare;
import weblogic.work.PartitionMinThreadsConstraint;
import weblogic.work.PartitionUtility;
import weblogic.work.PriorityRequestQueue;
import weblogic.work.RequestClass;
import weblogic.work.SelfTuningWorkManagerImpl;
import weblogic.work.ServiceClassStatsSupport;
import weblogic.work.ServiceClassSupport;
import weblogic.work.ServiceClassesStats;
import weblogic.work.StuckThreadAction;
import weblogic.work.StuckThreadManager;
import weblogic.work.ThreadPriorityManager;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkFilter;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;
import weblogic.work.WorkManagerImpl;
import weblogic.work.WorkManagerLogger;

public final class RequestManager {
    private static final int INCREMENT_ADVISOR_PERIOD = 2000;
    private static final int INCREMENT_ADVISOR_START_DELAY = 20000;
    private static final int MAX_STANDBY_THREADS = 256;
    private static final WorkAdapter ACTIVATE_REQUEST = new ActivateRequest();
    private static final WorkAdapter SHUTDOWN_REQUEST = new ShutdownRequest();
    private static final WorkAdapter THREADLOCAL_FORCE_CLEANUP_REQUEST = new ThreadLocalForceCleanupRequest();
    private final ArrayList<ExecuteThread> allThreads = new ArrayList(256);
    final PartitionAffinityThreadPool idleThreadPool = new PartitionAffinityThreadPool(IncrementAdvisor.getMaxThreadPoolSize(), false, isolatePartitionThreadLocal);
    final PartitionAffinityThreadPool standbyThreadPool = new PartitionAffinityThreadPool(256, true, isolatePartitionThreadLocal);
    private AtomicInteger runningThreadsCount = new AtomicInteger();
    final PriorityRequestQueue<WorkAdapter> queue;
    private AtomicInteger queueDepth = new AtomicInteger();
    private static boolean useEnhancedPriorityQueue;
    private static boolean allowShrinkingPriorityQueue;
    private static boolean useEnhancedIncrementAdvisor;
    private static boolean isolatePartitionThreadLocal;
    private AtomicInteger queueTouched = new AtomicInteger();
    private final ArrayList<ServiceClassSupport> requestClasses = new ArrayList();
    List<MinThreadsConstraint> minThreadsConstraints = new CopyOnWriteArrayList<MinThreadsConstraint>();
    private AtomicLong departures = new AtomicLong();
    private AtomicLong mtcDepartures = new AtomicLong();
    private final IncrementAdvisorIntf incrementAdvisor;
    private volatile int toDecrement;
    private AtomicInteger standbyThreadsCount = new AtomicInteger();
    private volatile int hogCounter;
    private volatile int longRunningThreadCount;
    private volatile boolean allNonStandbyThreadsExecutingMinTCWork;
    private int maxThreadIdValue;
    private final ThreadGroup threadGroup;
    private final BitSet recycledIDs = new BitSet();
    private final ServiceClassesStats stats = new ServiceClassesStats();
    private static boolean useBufferQueue;
    private PartialOrderSet<WorkAdapter> bufferWorkQueue;
    private static final StuckThreadAction DEFAULT_STUCK_THREAD_ACTION;
    private static final int USE_POOL_SIZE = -1;
    private int[] targetStandbyThreadPoolSize = new int[]{-1, -1, -1, -1, -1, 128, 64, 32, 16, 8, 4};
    private final String CMM_STANDBY_POOL_SIZE_PROPERTY = "weblogic.work.cmm.standbypoolsize";
    static final boolean INCLUDE_HOGS_IN_SELF_TUNING_STATS;
    static final boolean INCLUDE_LONG_RUNNING_THREADS_IN_SELF_TUNING_STATS;
    static boolean DISABLE_ALL_NON_STANDBY_THREADS_EXECUTING_MINTC_WORK;
    static final long THREAD_POOL_SIZE_LOG_INTERVAL_MILLIS;
    private long lastThreadPoolSizeLogTime;
    public static final DebugLogger debugRM;
    static RequestManager THE_ONE;
    private final Callable<Object, ExecuteThread> PUSH_AND_THEN = new Callable<Object, ExecuteThread>(){

        @Override
        public ExecuteThread call(Object o) {
            return RequestManager.this.idleThreadPool.poll(null);
        }
    };
    private final Callable<ExecuteThread, WorkAdapter> POP_OR_ELSE = new Callable<ExecuteThread, WorkAdapter>(){

        @Override
        public WorkAdapter call(ExecuteThread t) {
            RequestManager.this.runningThreadsCount.getAndDecrement();
            RequestManager.this.addToIdlePool(t, false);
            return null;
        }
    };

    private RequestManager() {
        if (useEnhancedPriorityQueue) {
            this.queue = new ConcurrentCalendarQueue<WorkAdapter>(allowShrinkingPriorityQueue, WorkAdapter.CHECK_EXPIRED_WORK);
            if (debugRM.isDebugEnabled()) {
                debugRM.debug("Enhanced CalendarQueue created");
            }
        } else {
            this.queue = new CalendarQueue<WorkAdapter>(allowShrinkingPriorityQueue, WorkAdapter.CHECK_EXPIRED_WORK);
            if (debugRM.isDebugEnabled()) {
                debugRM.debug("Classic CalendarQueue created");
            }
        }
        ThreadGroup tg = null;
        try {
            tg = new ThreadGroup("Pooled Threads");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.threadGroup = tg;
        TimerTask incrementAdvisorTask = null;
        if (useEnhancedIncrementAdvisor) {
            IncrementAdvisor2 ia2;
            incrementAdvisorTask = ia2 = new IncrementAdvisor2();
            this.incrementAdvisor = ia2;
            if (debugRM.isDebugEnabled()) {
                debugRM.debug("Enhanced IncrementAdvisor2 created");
            }
        } else {
            IncrementAdvisor ia = new IncrementAdvisor();
            incrementAdvisorTask = ia;
            this.incrementAdvisor = ia;
            if (debugRM.isDebugEnabled()) {
                debugRM.debug("Classic IncrementAdvisor created");
            }
        }
        if (KernelStatus.isServer()) {
            int delay = 20000;
            try {
                String s = System.getProperty("weblogic.work.increment.delay");
                if (s != null) {
                    delay = Integer.parseInt(s);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            new Timer(true).schedule(incrementAdvisorTask, delay, 2000L);
        }
        if (useBufferQueue) {
            this.bufferWorkQueue = new PartialOrderSet(8192);
            WorkManagerImpl.executeDaemonTask("RequestManagerPoller", 10, new BufferQueueDrainer());
        }
        String standbyPoolSizeProperty = System.getProperty("weblogic.work.cmm.standbypoolsize");
        this.loadTargetStandbyPoolSizeTable(standbyPoolSizeProperty);
    }

    public static RequestManager getInstance() {
        if (THE_ONE == null) {
            RequestManager.initSingleton();
        }
        return THE_ONE;
    }

    private static synchronized void initSingleton() {
        if (THE_ONE == null) {
            THE_ONE = new RequestManager();
        }
    }

    public static void enableBufferQueue(boolean flag) {
        useBufferQueue = flag;
    }

    public static void enableEnhancedPriorityQueue(boolean flag) {
        useEnhancedPriorityQueue = flag;
    }

    public static void enableAllowShrinkingPriorityQueue(boolean flag) {
        allowShrinkingPriorityQueue = flag;
    }

    public static void useEnhancedIncrementAdvisor(boolean flag) {
        useEnhancedIncrementAdvisor = flag;
    }

    public static void setIsolatePartitionThreadLocal(boolean flag) {
        isolatePartitionThreadLocal = flag;
    }

    static void initInternalRequests(SelfTuningWorkManagerImpl workManager) {
        ACTIVATE_REQUEST.setWorkManager(workManager);
        SHUTDOWN_REQUEST.setWorkManager(workManager);
        THREADLOCAL_FORCE_CLEANUP_REQUEST.setWorkManager(workManager);
        RequestManager.getInstance().incrPoolSize(IncrementAdvisor.getMinThreadPoolSize());
    }

    private void loadTargetStandbyPoolSizeTable(String propertyValue) {
        if (propertyValue == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(propertyValue, ",");
        for (int index = 0; st.hasMoreTokens() && index < this.targetStandbyThreadPoolSize.length; ++index) {
            String token = st.nextToken().trim();
            boolean valueValid = false;
            try {
                int entry = Integer.parseInt(token);
                if (entry >= 0 && entry <= 256 || entry == -1) {
                    this.targetStandbyThreadPoolSize[index] = entry;
                    valueValid = true;
                }
            }
            catch (NumberFormatException entry) {
                // empty catch block
            }
            if (valueValid || !debugRM.isDebugEnabled()) continue;
            debugRM.debug("Ignored value '" + token + "' at position " + index + " of property '" + "weblogic.work.cmm.standbypoolsize" + "'.");
        }
        if (debugRM.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.targetStandbyThreadPoolSize.length; ++i) {
                String size = this.targetStandbyThreadPoolSize[i] == -1 ? "USE_POOL_SIZE" : Integer.toString(this.targetStandbyThreadPoolSize[i]);
                sb.append(" Level " + i + "=" + size);
            }
            debugRM.debug("CMM Standby Thread Pool size set to: " + sb.toString());
        }
    }

    public boolean executeIt(WorkAdapter adapter) {
        try {
            return this.executeItInternal(adapter);
        }
        catch (ConstraintFullQueueException cfqe) {
            if (this.cancelTask(adapter, cfqe.getMessage())) {
                adapter.run();
                RequestManager.workCompleted(adapter);
            }
            return false;
        }
    }

    public boolean executeItWithRethrow(WorkAdapter adapter) throws ConstraintFullQueueException {
        try {
            return this.executeItInternal(adapter);
        }
        catch (ConstraintFullQueueException cfqe) {
            if (this.cancelTask(adapter, cfqe.getMessage())) {
                RequestManager.workCompleted(adapter);
                throw cfqe;
            }
            return false;
        }
    }

    private boolean cancelTask(WorkAdapter adapter, String cancelMessage) {
        Runnable cancelTask = adapter.cancel(cancelMessage);
        if (cancelTask != null) {
            cancelTask.run();
            RequestManager.workCompleted(adapter);
        }
        return cancelTask == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeItInternal(WorkAdapter entry) throws ConstraintFullQueueException {
        boolean b;
        entry.wm.accepted();
        long v = entry.getVersion();
        ExecuteThread t = this.idleThreadPool.poll(entry);
        if (t != null) {
            MaxThreadsConstraint mtc = entry.getMaxThreadsConstraint();
            if (mtc == null) {
                entry.wm.increaseMinThreadConstraintInProgress(false);
            } else {
                boolean b2;
                MaxThreadsConstraint maxThreadsConstraint = mtc;
                synchronized (maxThreadsConstraint) {
                    b2 = mtc.reserveIfConstraintNotReached();
                    if (b2) {
                        entry.wm.increaseMinThreadConstraintInProgress(false);
                    }
                }
                if (!b2) {
                    this.addToIdlePool(t, true);
                    this.addToMinAndPriorityQueue(entry, v);
                    return false;
                }
            }
            this.runningThreadsCount.getAndIncrement();
            t = this.standbyThreadPool.switchThreadWithPartitionAffinity(t, entry, true);
            this.setNextRequest(t, true, entry);
            return true;
        }
        MinThreadsConstraint minConstraint = entry.getMinThreadsConstraint();
        if (minConstraint == null) {
            this.queueDepth.getAndIncrement();
            this.addToPriorityQueue(entry, -1L);
            return false;
        }
        MaxThreadsConstraint mtc = entry.getMaxThreadsConstraint();
        if (mtc != null) {
            MaxThreadsConstraint maxThreadsConstraint = mtc;
            synchronized (maxThreadsConstraint) {
                b = minConstraint.tryAcquire();
                if (b) {
                    mtc.acquire();
                }
            }
        } else {
            b = minConstraint.tryAcquire();
        }
        if (!b) {
            this.addToMinAndPriorityQueue(entry, v);
            return false;
        }
        this.mtcDepartures.getAndIncrement();
        t = this.standbyThreadPool.poll(entry);
        if (t == null) {
            if (debugRM.isDebugEnabled()) {
                debugRM.debug("<executeIt> MinThread Constraint is violated but no idle thread in pool; hence creating a new thread");
            }
            entry.wm.started();
            entry.started();
            this.departures.getAndIncrement();
            this.createStandbyThreadAndExecute(this.threadID(), entry);
        } else {
            this.runningThreadsCount.getAndIncrement();
            this.setNextRequest(t, true, entry);
        }
        return true;
    }

    private void addToPriorityQueue(WorkAdapter work, long v) {
        if (useBufferQueue) {
            this.bufferWorkQueue.putMaybe(work, v);
        } else {
            this.addToCalendarQueue(work, v);
        }
    }

    private void addToCalendarQueue(WorkAdapter work, long v) {
        ExecuteThread t = this.queue.add(work, v, work.requestClass, this.PUSH_AND_THEN, null);
        if (t != null) {
            if (RequestManager.debugEnabled()) {
                RequestManager.log("Activating an idle thread as we have new work in Calendar Queue");
            }
            this.runningThreadsCount.getAndIncrement();
            this.executeWorkFromPriorityQueue(t, true);
        }
    }

    private void addToMinAndPriorityQueue(WorkAdapter entry, long v) throws ConstraintFullQueueException {
        this.queueDepth.getAndIncrement();
        MinThreadsConstraint minConstraint = entry.getMinThreadsConstraint();
        if (minConstraint != null) {
            try {
                minConstraint.add(entry, v);
            }
            catch (ConstraintFullQueueException cfqe) {
                this.queueDepth.getAndDecrement();
                throw cfqe;
            }
            this.addToPriorityQueue(entry, v);
        } else {
            this.addToPriorityQueue(entry, -1L);
        }
    }

    private void createThreadAndExecute(int threadId, WorkAdapter entry) {
        ExecuteThread t = this.createThread(threadId);
        this.startThread(t, entry);
    }

    private void createStandbyThreadAndExecute(int threadId, WorkAdapter entry) {
        ExecuteThread t = this.createThread(threadId);
        t.setStandby(true);
        this.standbyThreadsCount.getAndIncrement();
        this.startThread(t, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread(ExecuteThread t, WorkAdapter entry) {
        ArrayList<ExecuteThread> arrayList = this.allThreads;
        synchronized (arrayList) {
            this.allThreads.add(t);
        }
        this.runningThreadsCount.getAndIncrement();
        t.setRequest(entry);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecuteThread createThread(int threadId) {
        if (Thread.currentThread() instanceof ExecuteThread) {
            ClassLoader savedCL = Thread.currentThread().getContextClassLoader();
            ClassLoader defaultContextClassLoader = ((ExecuteThread)Thread.currentThread()).getDefaultContextClassLoader();
            Thread.currentThread().setContextClassLoader(defaultContextClassLoader);
            try {
                ExecuteThread executeThread = this.doCreateThreadUnderGlobalContext(threadId, "weblogic.kernel.Default (self-tuning)");
                return executeThread;
            }
            finally {
                Thread.currentThread().setContextClassLoader(savedCL);
            }
        }
        return this.doCreateThreadUnderGlobalContext(threadId, "weblogic.kernel.Default (self-tuning)");
    }

    private ExecuteThread doCreateThreadUnderGlobalContext(final int threadId, final String name) {
        try {
            return PartitionUtility.runWorkUnderGlobalContext(new java.util.concurrent.Callable<ExecuteThread>(){

                @Override
                public ExecuteThread call() throws Exception {
                    return new ExecuteThread(threadId, name, RequestManager.this.threadGroup);
                }
            });
        }
        catch (ExecutionException e) {
            ComponentInvocationContext currentContext = PartitionUtility.getCurrentComponentInvocationContext();
            if (!currentContext.isGlobalRuntime()) {
                WorkManagerLogger.logCreateThreadUnderGlobalContextFailed(e.getCause(), currentContext.getPartitionName());
            }
            return new ExecuteThread(threadId, name, this.threadGroup);
        }
    }

    public boolean executeIfIdle(WorkAdapter entry) {
        ExecuteThread t = this.idleThreadPool.poll(entry);
        if (t == null) {
            return false;
        }
        entry.wm.accepted();
        entry.wm.started();
        entry.wm.acquireMinMaxConstraint(false);
        entry.started();
        this.runningThreadsCount.getAndIncrement();
        this.departures.getAndIncrement();
        t.setRequest(entry, true);
        return true;
    }

    boolean registerIdle(ExecuteThread t, WorkAdapter previousEntry) {
        assert (previousEntry != SHUTDOWN_REQUEST) : "This thread was told to kill itself";
        if (previousEntry != null && previousEntry != ACTIVATE_REQUEST && previousEntry != THREADLOCAL_FORCE_CLEANUP_REQUEST) {
            this.updateStats(previousEntry, t);
            RequestManager.workCompleted(previousEntry);
        }
        if (!this.executeWorkFromMinOrMaxQueue(previousEntry, t)) {
            if (this.canBeDeactivated(previousEntry, t)) {
                this.runningThreadsCount.getAndDecrement();
                this.addToStandbyPool(t, false);
                return true;
            }
            return !this.executeWorkFromPriorityQueue(t, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canBeDeactivated(WorkAdapter prevWork, ExecuteThread t) {
        if (t.isStandby()) {
            return true;
        }
        if (prevWork != null && this.toDecrement > 0) {
            RequestManager requestManager = this;
            synchronized (requestManager) {
                if (this.toDecrement > 0) {
                    --this.toDecrement;
                    t.setStandby(true);
                    this.standbyThreadsCount.getAndIncrement();
                    return true;
                }
            }
        }
        return false;
    }

    void executeImmediately(WorkAdapter[] workList, boolean mtc) {
        if (workList == null || workList.length == 0) {
            return;
        }
        if (debugRM.isDebugEnabled()) {
            debugRM.debug("<executeImmediately> Got new jobs which need to be executed immediately " + workList.length, new Exception());
        }
        for (int cnt = 0; cnt < workList.length; ++cnt) {
            workList[cnt].wm.started();
            workList[cnt].started();
        }
        this.queueDepth.getAndAdd(-workList.length);
        if (mtc) {
            this.mtcDepartures.getAndAdd(workList.length);
        }
        this.departures.getAndAdd(workList.length);
        ArrayList<ExecuteThread> threads = this.getStandbyThreads(workList.length);
        int[] ids = this.threadID(workList.length - threads.size());
        this.executeWorkList(workList, threads, ids);
    }

    private ArrayList<ExecuteThread> getStandbyThreads(int mustRunCount) {
        ExecuteThread et;
        ArrayList<ExecuteThread> threads = new ArrayList<ExecuteThread>();
        while (mustRunCount-- > 0 && (et = this.standbyThreadPool.poll(null)) != null) {
            threads.add(et);
        }
        return threads;
    }

    private void executeWorkList(WorkAdapter[] workList, ArrayList<ExecuteThread> threads, int[] ids) {
        int count = 0;
        for (ExecuteThread et : threads) {
            this.runningThreadsCount.getAndIncrement();
            et.setRequest(workList[count++], true);
        }
        if (debugRM.isDebugEnabled()) {
            debugRM.debug("<executeWorkList> creating new threads " + ids.length);
        }
        for (Object i : (Object)ids) {
            this.createStandbyThreadAndExecute((int)i, workList[count++]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkAdapter getMaxConstraintWork(WorkAdapter previousEntry, boolean isStandbyThread) {
        WorkAdapter work;
        assert (previousEntry != null) : "Previous work entry can't be null";
        MaxThreadsConstraint mtc = previousEntry.getMaxThreadsConstraint();
        if (mtc == null) {
            return null;
        }
        MaxThreadsConstraint maxThreadsConstraint = mtc;
        synchronized (maxThreadsConstraint) {
            work = mtc.getNext();
            if (work == null) {
                mtc.release();
                return null;
            }
        }
        MinThreadsConstraint wmin = work.getMinThreadsConstraint();
        if (wmin != null) {
            wmin.acquire(isStandbyThread);
        }
        return work;
    }

    private static void workCompleted(WorkAdapter previousEntry) {
        previousEntry.wm.completed();
        previousEntry.returnForReuse();
    }

    private static void reclaimStuckThread(WorkAdapter previousEntry, ExecuteThread t) {
        t.setStuckThread(null);
        RequestManager.notifyWMOfThreadUnstuck(t);
        T3SrvrLogger.logInfoUnstuckThread(t.getName());
        StuckThreadManager stm = previousEntry.getWorkManager().getStuckThreadManager();
        if (stm != null) {
            stm.threadUnStuck(t.id);
        }
    }

    private boolean executeWorkFromMinOrMaxQueue(WorkAdapter previousEntry, ExecuteThread t) {
        if (previousEntry == null) {
            return false;
        }
        MaxThreadsConstraint maxC = previousEntry.getMaxThreadsConstraint();
        if (maxC != null && maxC.releaseIfConstraintOverSubscribed()) {
            MinThreadsConstraint minC = previousEntry.getMinThreadsConstraint();
            if (minC != null) {
                minC.release(t.isStandby());
            }
            return false;
        }
        WorkAdapter next = this.getMinConstraintWork(previousEntry, t.isStandby());
        if (next == null && (next = RequestManager.getMaxConstraintWork(previousEntry, t.isStandby())) == null) {
            return false;
        }
        this.queueDepth.getAndDecrement();
        this.setNextRequest(t, false, next);
        return true;
    }

    private boolean executeWorkFromPriorityQueue(ExecuteThread t, boolean notifyThread) {
        WorkAdapter next = this.queue.pop(MaxThreadsConstraint.CHECK_MAX_CONSTRAINT, this.POP_OR_ELSE, t);
        this.queueTouched.getAndIncrement();
        if (next == null) {
            return false;
        }
        next.wm.increaseMinThreadConstraintInProgress(t.isStandby());
        this.queueDepth.getAndDecrement();
        ExecuteThread executeThread = this.standbyThreadPool.switchThreadWithPartitionAffinity(t, next, false);
        if (t != executeThread) {
            notifyThread = true;
        }
        this.setNextRequest(executeThread, notifyThread, next);
        return true;
    }

    private void setNextRequest(ExecuteThread t, boolean notifyThread, WorkAdapter next) {
        next.wm.started();
        next.started();
        this.departures.getAndIncrement();
        t.setRequest(next, notifyThread);
    }

    private void updateStats(WorkAdapter previousEntry, ExecuteThread t) {
        if (t.isStuck()) {
            RequestManager.reclaimStuckThread(previousEntry, t);
        }
        RequestManager.updateRequestClass((ServiceClassStatsSupport)((Object)previousEntry.requestClass), t);
        t.setHog(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateRequestClass(ServiceClassStatsSupport previousRequestClass, ExecuteThread t) {
        if (previousRequestClass != null) {
            if (useEnhancedIncrementAdvisor) {
                long usageNS = t.updateTimeStampAndReturnCurrentThreadUsageNS();
                ServiceClassStatsSupport serviceClassStatsSupport = previousRequestClass;
                synchronized (serviceClassStatsSupport) {
                    ++previousRequestClass.completedCount;
                    if (!INCLUDE_HOGS_IN_SELF_TUNING_STATS && t.isHog() || !INCLUDE_LONG_RUNNING_THREADS_IN_SELF_TUNING_STATS && t.isLongRunningTask()) {
                        previousRequestClass.threadUseHogNS += usageNS;
                    } else {
                        previousRequestClass.threadUseNS += usageNS;
                    }
                }
            }
            int usage = t.updateTimeStampAndReturnCurrentThreadUsage();
            ServiceClassStatsSupport serviceClassStatsSupport = previousRequestClass;
            synchronized (serviceClassStatsSupport) {
                ++previousRequestClass.completedCount;
                previousRequestClass.totalThreadUse += (long)usage;
                previousRequestClass.threadUseSquares += (long)(usage * usage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activeRequestClassesInOverload() {
        ArrayList<ServiceClassSupport> sortedRequestClasses;
        if (this.requestClasses.size() == 0) {
            return;
        }
        OverloadManager om = SelfTuningWorkManagerImpl.SHARED_OVERLOAD_MANAGER;
        boolean updateGlobal = false;
        if (om != null) {
            boolean bl = updateGlobal = this.getTotalRequestsCount() >= om.getCapacity();
            if (!updateGlobal) {
                om.resetActiveRequestClassesInOverload();
            }
        }
        List<OverloadManager> nearCapacityOverloadManagers = OverloadManager.getListOfNearCapacityPartitionOverloadManager();
        if (!updateGlobal && nearCapacityOverloadManagers == null) {
            return;
        }
        ArrayList<ServiceClassSupport> arrayList = this.requestClasses;
        synchronized (arrayList) {
            sortedRequestClasses = new ArrayList<ServiceClassSupport>(this.requestClasses);
        }
        Collections.sort(sortedRequestClasses);
        if (updateGlobal) {
            om.activeRequestClassNamesInOverload(sortedRequestClasses);
        }
        if (nearCapacityOverloadManagers != null) {
            for (OverloadManager overloadManager : nearCapacityOverloadManagers) {
                overloadManager.activeRequestClassNamesInOverload(sortedRequestClasses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateElapsedTime(long elapsedTime) {
        this.stats.reset();
        ArrayList<ServiceClassSupport> arrayList = this.requestClasses;
        synchronized (arrayList) {
            for (RequestClass requestClass : this.requestClasses) {
                if (requestClass == null) continue;
                requestClass.timeElapsed(elapsedTime, this.stats);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeThreadUsage(long[] holder) {
        long completed = 0L;
        long threadTime = 0L;
        ArrayList<ServiceClassSupport> arrayList = this.requestClasses;
        synchronized (arrayList) {
            for (ServiceClassStatsSupport serviceClassStatsSupport : this.requestClasses) {
                if (serviceClassStatsSupport == null) continue;
                completed += serviceClassStatsSupport.getCompleted();
                threadTime += serviceClassStatsSupport.getThreadUse();
            }
        }
        holder[0] = completed;
        holder[1] = threadTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long computeThreadUsageNS(long[] holder) {
        long completed = 0L;
        long threadTime = 0L;
        long hogThreadTime = 0L;
        ArrayList<ServiceClassSupport> arrayList = this.requestClasses;
        synchronized (arrayList) {
            for (ServiceClassStatsSupport serviceClassStatsSupport : this.requestClasses) {
                if (serviceClassStatsSupport == null) continue;
                completed += serviceClassStatsSupport.getCompletedCountDelta();
                threadTime += serviceClassStatsSupport.getAndResetThreadUseNS();
                hogThreadTime += serviceClassStatsSupport.lastThreadUseHogNS;
            }
        }
        holder[0] = (threadTime + 500000L) / 1000000L;
        holder[1] = (hogThreadTime + 500000L) / 1000000L;
        return completed;
    }

    void computeThreadPriorities() {
        ThreadPriorityManager.getInstance().computeThreadPriorities(this.requestClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ServiceClassSupport scs) {
        ArrayList<ServiceClassSupport> arrayList = this.requestClasses;
        synchronized (arrayList) {
            this.requestClasses.add(scs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(ServiceClassSupport scs) {
        ArrayList<ServiceClassSupport> arrayList = this.requestClasses;
        synchronized (arrayList) {
            this.requestClasses.remove(scs);
        }
    }

    public void register(MinThreadsConstraint mtc) {
        if (mtc != null) {
            this.minThreadsConstraints.add(mtc);
        }
    }

    public void deregister(MinThreadsConstraint mtc) {
        if (mtc != null) {
            this.minThreadsConstraints.remove(mtc);
        }
    }

    void processStartPartition(String partitionName, boolean rcmEnabled) {
        this.idleThreadPool.addPartition(partitionName, rcmEnabled);
        this.standbyThreadPool.addPartition(partitionName, rcmEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupForPartition(String partitionName) {
        if (partitionName == null) {
            return;
        }
        ArrayList<MinThreadsConstraint> mtcToRemove = new ArrayList<MinThreadsConstraint>();
        for (MinThreadsConstraint minThreadsConstraint : this.minThreadsConstraints) {
            PartitionMinThreadsConstraint partitionMinThreadsConstraint = minThreadsConstraint.getPartitionMinThreadsConstraint();
            if (partitionMinThreadsConstraint == null || !partitionName.equals(partitionMinThreadsConstraint.getPartitionName())) continue;
            mtcToRemove.add(minThreadsConstraint);
        }
        this.minThreadsConstraints.removeAll(mtcToRemove);
        ArrayList<ServiceClassSupport> rcToRemove = new ArrayList<ServiceClassSupport>();
        ArrayList<ServiceClassSupport> arrayList = this.requestClasses;
        synchronized (arrayList) {
            for (ServiceClassSupport requestClass : this.requestClasses) {
                PartitionFairShare partitionFairShare = requestClass.getPartitionFairShare();
                if (partitionFairShare == null || !partitionName.equals(partitionFairShare.getName())) continue;
                rcToRemove.add(requestClass);
            }
            this.requestClasses.removeAll(rcToRemove);
        }
        List<ExecuteThread> list = this.standbyThreadPool.removePartition(partitionName);
        for (ExecuteThread extraStandbyThread : list) {
            this.retireStandbyThread(extraStandbyThread, true);
        }
        if (!list.isEmpty()) {
            WorkManagerLogger.logRemovedStandbyThreads(list.size());
        }
        List<ExecuteThread> extraIdleThreads = this.idleThreadPool.removePartition(partitionName);
        for (ExecuteThread extraIdleThread : extraIdleThreads) {
            this.standbyThreadsCount.getAndIncrement();
            this.addToStandbyPool(extraIdleThread, true);
        }
    }

    private WorkAdapter getMinConstraintWork(WorkAdapter previousEntry, boolean isStandbyThread) {
        assert (previousEntry != null) : "Previous work entry can't be null";
        MinThreadsConstraint mtc = previousEntry.getMinThreadsConstraint();
        if (mtc == null) {
            return null;
        }
        WorkAdapter work = mtc.getNext(isStandbyThread, this.getIdleThreadCount() > 0);
        if (work != null) {
            this.mtcDepartures.getAndIncrement();
            MaxThreadsConstraint pmax = previousEntry.getMaxThreadsConstraint();
            MaxThreadsConstraint wmax = work.getMaxThreadsConstraint();
            if (pmax != wmax) {
                if (pmax != null) {
                    pmax.release();
                }
                if (wmax != null) {
                    wmax.acquire();
                }
            }
        }
        return work;
    }

    long getMinThreadsConstraintsCompleted() {
        return this.mtcDepartures.get();
    }

    int getMustRunCount() {
        int addup = 0;
        for (MinThreadsConstraint mtc : this.minThreadsConstraints) {
            addup += mtc.getMustRunCount();
        }
        return addup;
    }

    private boolean addToIdlePool(ExecuteThread t, boolean notifyThread) {
        if (!this.idleThreadPool.offer(t)) {
            t.setStandby(true);
            this.standbyThreadsCount.getAndIncrement();
            return this.addToStandbyPool(t, notifyThread);
        }
        return true;
    }

    private boolean addToStandbyPool(ExecuteThread t, boolean notifyThread) {
        t.forceEraseThreadLocals();
        if (!this.standbyThreadPool.offer(t)) {
            this.retireStandbyThread(t, notifyThread);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retireStandbyThread(ExecuteThread t, boolean notifyThread) {
        this.standbyThreadsCount.getAndDecrement();
        Object object = this;
        synchronized (object) {
            this.recycledIDs.set(t.id);
        }
        object = this.allThreads;
        synchronized (object) {
            this.allThreads.remove(t);
        }
        t.setRequest(SHUTDOWN_REQUEST, notifyThread);
    }

    void handleMemoryPressure(int memLevel) {
        if (memLevel < 0 || memLevel >= this.targetStandbyThreadPoolSize.length) {
            return;
        }
        int targetStandbyPoolSize = this.targetStandbyThreadPoolSize[memLevel];
        if (targetStandbyPoolSize == -1 || targetStandbyPoolSize > 256) {
            targetStandbyPoolSize = 256;
        }
        this.standbyThreadPool.setLimit(targetStandbyPoolSize);
        this.purgeStandbyThreads(targetStandbyPoolSize);
    }

    void purgeStandbyThreads(int targetNumThreads) {
        int toPurge = this.standbyThreadPool.size() - targetNumThreads;
        ExecuteThread t = null;
        int numThreadsPurged = 0;
        while (toPurge-- > 0 && (t = this.standbyThreadPool.poll(null)) != null) {
            this.retireStandbyThread(t, true);
            ++numThreadsPurged;
        }
        if (numThreadsPurged > 0) {
            WorkManagerLogger.logRemovedStandbyThreads(numThreadsPurged);
        }
    }

    public void cleanupThreadPoolTLs() {
        if (!ExecuteThread.isCleanupTLAfterEachRequest()) {
            ExecuteThread.updateRequestTLTime();
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                @Override
                public void run() {
                    RequestManager.getInstance().cleanupThreadLocals();
                }
            });
        }
    }

    private void cleanupThreadLocals() {
        ExecuteThread t;
        while ((t = this.idleThreadPool.poll(null)) != null) {
            this.runningThreadsCount.getAndIncrement();
            RequestManager.ACTIVATE_REQUEST.wm.acquireMinMaxConstraint(false);
            t.setRequest(ACTIVATE_REQUEST, true);
        }
    }

    boolean doForceCleanupThreadlocal(ExecuteThread thread) {
        if (Thread.currentThread() == thread) {
            thread.forceEraseThreadLocals();
            return true;
        }
        this.runningThreadsCount.getAndIncrement();
        RequestManager.THREADLOCAL_FORCE_CLEANUP_REQUEST.wm.acquireMinMaxConstraint(false);
        thread.setRequest(THREADLOCAL_FORCE_CLEANUP_REQUEST, true);
        return false;
    }

    private void logThreadPoolSize(long currentTime) {
        if (currentTime - this.lastThreadPoolSizeLogTime >= THREAD_POOL_SIZE_LOG_INTERVAL_MILLIS) {
            this.lastThreadPoolSizeLogTime = currentTime;
            WorkManagerLogger.logSelfTuningThreadCounts(this.runningThreadsCount.get(), this.getIdleThreadCount(), this.standbyThreadsCount.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int purgeHogs(int duration) {
        ExecuteThread[] allThreadsArray;
        if (this.toDecrement != 0) {
            RequestManager requestManager = this;
            synchronized (requestManager) {
                this.toDecrement = 0;
            }
        }
        long currentTime = System.currentTimeMillis();
        this.logThreadPoolSize(currentTime);
        long threshold = currentTime - (long)duration;
        int hogCount = 0;
        int totalThreadsChecked = 0;
        int longRunningTaskThreads = 0;
        int executingNonStandby = 0;
        int executingNonStandbyRunningMinTCWork = 0;
        for (ExecuteThread t : allThreadsArray = this.getAllThreads()) {
            ++totalThreadsChecked;
            WorkAdapter r = t.getCurrentWork();
            if (r == null || !t.isUnderExecution()) continue;
            if (!t.isStandby()) {
                ++executingNonStandby;
                SelfTuningWorkManagerImpl wm = t.getWorkManager();
                if (wm != null && wm.min != null) {
                    ++executingNonStandbyRunningMinTCWork;
                }
            }
            if (!INCLUDE_LONG_RUNNING_THREADS_IN_SELF_TUNING_STATS && t.isLongRunningTask()) {
                ++longRunningTaskThreads;
            }
            if (threshold <= t.getTimeStamp()) continue;
            t.setHog(true);
            if (t.isStandby()) continue;
            ++hogCount;
        }
        this.hogCounter = hogCount;
        this.longRunningThreadCount = longRunningTaskThreads;
        this.allNonStandbyThreadsExecutingMinTCWork = executingNonStandby > 0 && executingNonStandby == executingNonStandbyRunningMinTCWork;
        int size = totalThreadsChecked - (hogCount + this.standbyThreadsCount.get() + longRunningTaskThreads);
        return size < 0 ? 0 : size;
    }

    private synchronized int threadID() {
        int i = this.recycledIDs.nextSetBit(0);
        if (i < 0) {
            return this.maxThreadIdValue++;
        }
        this.recycledIDs.clear(i);
        return i;
    }

    private synchronized int[] threadID(int count) {
        int[] ids = new int[count];
        for (int cnt = 0; cnt < count; ++cnt) {
            ids[cnt] = this.threadID();
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrPoolSize(int incr) {
        ExecuteThread t;
        if (incr == 0) {
            return;
        }
        if (incr < 0) {
            ExecuteThread t2;
            if (debugRM.isDebugEnabled()) {
                debugRM.debug("<incrPoolSize> Decrease idleThread Pool size by " + -incr);
            }
            while (incr < 0 && (t2 = this.idleThreadPool.poll(null)) != null) {
                ++incr;
                t2.setStandby(true);
                this.standbyThreadsCount.getAndIncrement();
                this.addToStandbyPool(t2, true);
            }
            if (incr < 0) {
                RequestManager requestManager = this;
                synchronized (requestManager) {
                    this.toDecrement = -incr;
                }
            }
            return;
        }
        int incrementCount = IncrementAdvisor.getMaxThreadPoolSize() - this.getExecuteThreadCount() + this.standbyThreadsCount.get();
        if (incrementCount <= 0) {
            return;
        }
        for (incrementCount = Math.min(incr, incrementCount); incrementCount > 0 && (t = this.standbyThreadPool.poll(null)) != null; --incrementCount) {
            t.setStandby(false);
            this.standbyThreadsCount.getAndDecrement();
            this.runningThreadsCount.getAndIncrement();
            RequestManager.ACTIVATE_REQUEST.wm.acquireMinMaxConstraint(false);
            t.setRequest(ACTIVATE_REQUEST, true);
        }
        if (incrementCount <= 0) {
            return;
        }
        if (debugRM.isDebugEnabled()) {
            debugRM.debug("<incrPoolSize> Adding new threads " + incrementCount);
        }
        this.createIdleThreads(incrementCount);
    }

    private void createIdleThreads(int size) {
        int[] ids;
        for (int id : ids = this.threadID(size)) {
            if (RequestManager.ACTIVATE_REQUEST.wm != null) {
                RequestManager.ACTIVATE_REQUEST.wm.acquireMinMaxConstraint(false);
            }
            this.createThreadAndExecute(id, ACTIVATE_REQUEST);
        }
    }

    private void createStandbyThreads(int size) {
        int[] ids;
        for (int id : ids = this.threadID(size)) {
            if (RequestManager.ACTIVATE_REQUEST.wm != null) {
                RequestManager.ACTIVATE_REQUEST.wm.acquireMinMaxConstraint(true);
            }
            this.createStandbyThreadAndExecute(id, ACTIVATE_REQUEST);
        }
    }

    public int getQueueDepth() {
        int size = this.queueDepth.get();
        return size < 0 ? 0 : size;
    }

    public int getTotalRequestsCount() {
        return this.getQueueDepth() + this.runningThreadsCount.get();
    }

    int getRunningThreadsCount() {
        return this.runningThreadsCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExecuteThreadCount() {
        ArrayList<ExecuteThread> arrayList = this.allThreads;
        synchronized (arrayList) {
            return this.allThreads.size();
        }
    }

    public int getExecuteThreadCount(String partitionName) {
        return this.getExecuteThreads(partitionName).length;
    }

    public long getQueueDepartures() {
        return this.departures.get();
    }

    public int getIdleThreadCount() {
        return this.idleThreadPool.size();
    }

    public int getStandbyCount() {
        return this.standbyThreadPool.size();
    }

    int getHogSize() {
        return this.hogCounter;
    }

    int getLongRunningThreadCount() {
        return this.longRunningThreadCount;
    }

    boolean isAllNonStandbyThreadsExecutingMinTCWork() {
        if (DISABLE_ALL_NON_STANDBY_THREADS_EXECUTING_MINTC_WORK) {
            return false;
        }
        return this.allNonStandbyThreadsExecutingMinTCWork;
    }

    ArrayList<ExecuteThread> getStuckThreads(long maxTime, String partitionName) {
        ExecuteThread[] allThreadsArray;
        long currentTime = System.currentTimeMillis();
        ArrayList<ExecuteThread> stuckThreadList = new ArrayList<ExecuteThread>();
        if (this.hogCounter == 0 || maxTime == 0L) {
            return null;
        }
        for (ExecuteThread thread : allThreadsArray = this.getAllThreads()) {
            StuckThreadAction stuckThreadAction;
            if (thread.getCurrentWork() == null || partitionName != null && !partitionName.equals(thread.getPartitionName()) || (stuckThreadAction = RequestManager.isThreadStuck(thread, currentTime, maxTime)) == null) continue;
            stuckThreadList.add(thread);
            if (thread.isStuck()) continue;
            RequestManager.notifyWMOfStuckThread(thread);
            thread.setStuckThread(stuckThreadAction);
            ThreadPriorityManager.handleHogger(thread, thread.isExecutingInternalWork());
        }
        return stuckThreadList;
    }

    private static StuckThreadAction isThreadStuck(ExecuteThread thread, long currentTime, long maxTime) {
        if (thread == null) {
            return null;
        }
        WorkAdapter currentWork = thread.getCurrentWork();
        if (currentWork == null || currentWork == ACTIVATE_REQUEST || currentWork == SHUTDOWN_REQUEST) {
            return null;
        }
        SelfTuningWorkManagerImpl wm = currentWork.getWorkManager();
        if (wm == null || wm.isInternal()) {
            return null;
        }
        long timeStamp = thread.getTimeStamp();
        if (timeStamp <= 0L) {
            return null;
        }
        long elapsedTime = currentTime - timeStamp;
        StuckThreadManager stm = wm.getStuckThreadManager();
        if (stm != null) {
            return stm.threadStuck(thread, elapsedTime, maxTime);
        }
        if (elapsedTime >= maxTime) {
            return DEFAULT_STUCK_THREAD_ACTION;
        }
        return null;
    }

    private static void notifyWMOfStuckThread(ExecuteThread thread) {
        SelfTuningWorkManagerImpl swm = thread.getWorkManager();
        if (swm != null) {
            swm.stuck();
        }
    }

    private static void notifyWMOfThreadUnstuck(ExecuteThread thread) {
        SelfTuningWorkManagerImpl swm = thread.getWorkManager();
        if (swm != null) {
            swm.unstuck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecuteThread[] getExecuteThreads(String partitionName) {
        ArrayList<ExecuteThread> threadsList = new ArrayList<ExecuteThread>();
        ArrayList<ExecuteThread> arrayList = this.allThreads;
        synchronized (arrayList) {
            for (ExecuteThread thread : this.allThreads) {
                if (partitionName != null && !partitionName.equals(thread.getPartitionName())) continue;
                threadsList.add(thread);
            }
        }
        ExecuteThread[] threads = new ExecuteThread[threadsList.size()];
        threadsList.toArray(threads);
        return threads;
    }

    public ExecuteThread[] getAllThreads() {
        return this.getExecuteThreads(null);
    }

    void releaseExecutingRequestFor(WorkManager wm, WorkFilter filter) {
        ArrayList<WorkAdapter> works = new ArrayList<WorkAdapter>();
        ExecuteThread[] allThreadsArray = this.getAllThreads();
        for (ExecuteThread et : allThreadsArray) {
            WorkAdapter work;
            if (wm != et.getWorkManager() || (work = et.getCurrentWork()) == null || filter != null && !filter.matches(work)) continue;
            works.add(work);
        }
        for (WorkAdapter work : works) {
            work.release();
        }
    }

    void releaseExecutingRequestFor(WorkManager wm) {
        this.releaseExecutingRequestFor(wm, null);
    }

    double getThroughput() {
        return this.incrementAdvisor.getThroughput();
    }

    int getAndResetQueueTouched() {
        return this.queueTouched.getAndSet(0);
    }

    String getConciseStateDump() {
        return "Qsize:" + this.queue.size() + ",Qdepth:" + this.getQueueDepth() + ",all:" + this.getExecuteThreadCount() + ",running:" + this.getRunningThreadsCount() + ",idle:" + this.getIdleThreadCount() + ",standby:" + this.getStandbyCount() + ",hog:" + this.getHogSize() + ",longRunning:" + this.getLongRunningThreadCount() + ",departure:" + this.getQueueDepartures() + ",outoforder:" + this.getMinThreadsConstraintsCompleted();
    }

    boolean isBusyForScheduleIfBusy() {
        return this.incrementAdvisor.isThreadPoolBusy();
    }

    long getRequestQueueMaxValue() {
        return this.queue.getMaxValue();
    }

    private static boolean debugEnabled() {
        return SelfTuningWorkManagerImpl.debugEnabled();
    }

    private static void log(String str) {
        SelfTuningWorkManagerImpl.debug("<RequestManager> " + str);
    }

    static {
        DEFAULT_STUCK_THREAD_ACTION = new DefaultStuckThreadAction();
        INCLUDE_HOGS_IN_SELF_TUNING_STATS = Boolean.getBoolean("weblogic.work.includeHogsInSelfTuningStats");
        INCLUDE_LONG_RUNNING_THREADS_IN_SELF_TUNING_STATS = Boolean.getBoolean("weblogic.work.includeLongRunningInSelfTuningStats");
        DISABLE_ALL_NON_STANDBY_THREADS_EXECUTING_MINTC_WORK = Boolean.getBoolean("weblogic.work.disableAddThreadWhenAllThreadsExecutingMinTCWork");
        THREAD_POOL_SIZE_LOG_INTERVAL_MILLIS = 1000L * (long)Integer.getInteger("weblogic.work.threadPoolSizeLogIntervalSeconds", 120).intValue();
        debugRM = DebugLogger.getDebugLogger("DebugRequestManager");
    }

    private static class DefaultStuckThreadAction
    implements StuckThreadAction {
        private DefaultStuckThreadAction() {
        }

        @Override
        public boolean threadStuck(int threadId, long elapsedTime, long maxTime) {
            return false;
        }

        @Override
        public void threadUnStuck(int threadId) {
        }

        @Override
        public int getStuckThreadCount() {
            return 0;
        }

        @Override
        public void execute() {
        }

        @Override
        public void withdraw() {
        }

        @Override
        public String getName() {
            return "server-failure-trigger";
        }

        @Override
        public long getMaxStuckTime() {
            return 0L;
        }
    }

    private static final class ThreadLocalForceCleanupRequest
    extends WorkAdapter {
        private ThreadLocalForceCleanupRequest() {
        }

        @Override
        public void run() {
            ExecuteThread currentThread = (ExecuteThread)Thread.currentThread();
            currentThread.forceEraseThreadLocals();
        }
    }

    static final class ShutdownError
    extends Error {
        ShutdownError() {
        }
    }

    private static final class ShutdownRequest
    extends WorkAdapter {
        private ShutdownRequest() {
        }

        @Override
        public void run() {
            throw new ShutdownError();
        }
    }

    private static final class ActivateRequest
    extends WorkAdapter {
        private ActivateRequest() {
        }

        @Override
        public void run() {
        }
    }

    private class BufferQueueDrainer
    implements MaybeMapper<WorkAdapter>,
    Runnable {
        private BufferQueueDrainer() {
        }

        @Override
        public WorkAdapter unbox(WorkAdapter work, long v) {
            if (work.isCurrentVersion(v)) {
                RequestManager.this.addToCalendarQueue(work, v);
            }
            return work;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        RequestManager.this.bufferWorkQueue.take(this);
                    }
                }
                catch (Throwable ie) {
                    if (!debugRM.isDebugEnabled()) continue;
                    debugRM.debug("RM.BufferQueueDrainer.run() ignore unexpected " + ie);
                    continue;
                }
                break;
            }
        }
    }

    static interface Callable<V, T> {
        public T call(V var1);
    }
}

