/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import com.oracle.core.registryhelper.utils.MonitorableMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.work.FairShareRequestClass;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.MinThreadsConstraint;
import weblogic.work.OverloadManager;
import weblogic.work.PartitionUtility;
import weblogic.work.RequestClass;
import weblogic.work.RequestManager;
import weblogic.work.ResponseTimeRequestClass;
import weblogic.work.SelfTuningWorkManagerImpl;
import weblogic.work.ServiceClassSupport;
import weblogic.work.StuckThreadManager;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class SelfTuningWorkManagerFactory
extends WorkManagerFactory {
    protected ConcurrentHashMap<String, PartitionWorkManagersHolder> partitionWorkManagerMaps = new ConcurrentHashMap();

    SelfTuningWorkManagerFactory() {
    }

    public static synchronized void initialize(int capacity) {
        if (SINGLETON != null) {
            return;
        }
        SINGLETON = new SelfTuningWorkManagerFactory();
        SelfTuningWorkManagerImpl.initialize(capacity);
        ((SelfTuningWorkManagerFactory)SINGLETON).initializeHere();
    }

    public static synchronized WorkManagerFactory getInstance() {
        if (SINGLETON != null) {
            return SINGLETON;
        }
        SelfTuningWorkManagerFactory.initialize(65536);
        return SINGLETON;
    }

    protected void initializeHere() {
        this.REJECTOR = this.create("weblogic.Rejector", 5, -1);
        this.DEFAULT = this.create("weblogic.kernel.Default", -1, -1);
        this.SYSTEM = this.create("weblogic.kernel.System", 5, -1);
        SelfTuningWorkManagerImpl nonBlocking = this.create("weblogic.kernel.Non-Blocking", 3, -1);
        SelfTuningWorkManagerImpl direct = this.create("direct", -1, -1);
        this.byName.put("weblogic.kernel.System", this.SYSTEM);
        this.byName.put("weblogic.kernel.Non-Blocking", nonBlocking);
        this.byName.put("direct", direct);
        this.createDomainWorkManagers(this.byName);
        RequestManager.initInternalRequests((SelfTuningWorkManagerImpl)this.SYSTEM);
    }

    protected PartitionWorkManagersHolder createPartitionWorkManagerHolder() {
        MonitorableMap<String, WorkManager> map = new MonitorableMap<String, WorkManager>();
        SelfTuningWorkManagerImpl rejector = this.create("weblogic.Rejector", 5, -1);
        SelfTuningWorkManagerImpl defaultWM = this.create("weblogic.kernel.Default", -1, -1);
        SelfTuningWorkManagerImpl system = this.create("weblogic.kernel.System", 5, -1);
        SelfTuningWorkManagerImpl nonBlocking = this.create("weblogic.kernel.Non-Blocking", 3, -1);
        SelfTuningWorkManagerImpl direct = this.create("direct", -1, -1);
        map.put("weblogic.kernel.System", system);
        map.put("weblogic.kernel.Non-Blocking", nonBlocking);
        map.put("direct", direct);
        this.createDomainWorkManagers(map);
        return new PartitionWorkManagersHolder(map, system, defaultWM, rejector);
    }

    protected void createDomainWorkManagers(Map<String, WorkManager> map) {
    }

    void startPartitionWorkManagerHolder() {
        MonitorableMap<String, WorkManager> domainWorkManagers = this.getDomainWorkManagersMap();
        this.startDomainWorkManagers(domainWorkManagers);
    }

    protected void startDomainWorkManagers(Map<String, WorkManager> domainWorkManagers) {
    }

    void stopPartitionWorkManagerHolder() {
        MonitorableMap<String, WorkManager> domainWorkManagers = this.getDomainWorkManagersMap();
        this.stopDomainWorkManagers(domainWorkManagers);
        ComponentInvocationContext componentInvocationContext = PartitionUtility.getCurrentComponentInvocationContext();
        if (!componentInvocationContext.isGlobalRuntime()) {
            String partitionID = componentInvocationContext.getPartitionId();
            this.partitionWorkManagerMaps.remove(partitionID);
        }
    }

    protected void stopDomainWorkManagers(Map<String, WorkManager> domainWorkManagers) {
    }

    @Override
    public final WorkManager getSystem() {
        PartitionWorkManagersHolder partitionWorkManagersHolder = this.getPartitionWorkManagerHolderForCurrentPartition();
        if (partitionWorkManagersHolder == null) {
            return this.SYSTEM;
        }
        return partitionWorkManagersHolder.getSystem();
    }

    @Override
    public final WorkManager getDefault() {
        PartitionWorkManagersHolder partitionWorkManagersHolder = this.getPartitionWorkManagerHolderForCurrentPartition();
        if (partitionWorkManagersHolder == null) {
            return this.DEFAULT;
        }
        return partitionWorkManagersHolder.getDefault();
    }

    @Override
    protected final WorkManager getRejector() {
        PartitionWorkManagersHolder partitionWorkManagersHolder = this.getPartitionWorkManagerHolderForCurrentPartition();
        if (partitionWorkManagersHolder == null) {
            return this.REJECTOR;
        }
        return partitionWorkManagersHolder.getRejector();
    }

    protected SelfTuningWorkManagerImpl create(String workManagerName, int minThreadsConstraint, int maxThreadsConstraint) {
        return this.create(workManagerName, -1, -1, minThreadsConstraint, maxThreadsConstraint);
    }

    protected SelfTuningWorkManagerImpl create(String workManagerName, int fairshare, int responseTime, int minThreadsConstraint, int maxThreadsConstraint) {
        MinThreadsConstraint min = null;
        if (minThreadsConstraint != -1) {
            min = new MinThreadsConstraint(workManagerName, minThreadsConstraint);
            min.setShared(false);
        }
        MaxThreadsConstraint max = null;
        if (maxThreadsConstraint != -1) {
            max = new MaxThreadsConstraint(workManagerName, maxThreadsConstraint);
            max.setShared(false);
        }
        ServiceClassSupport requestClass = null;
        if (responseTime > 0) {
            requestClass = new ResponseTimeRequestClass(workManagerName, responseTime);
        } else if (fairshare > 0) {
            requestClass = new FairShareRequestClass(workManagerName, fairshare);
        }
        return SelfTuningWorkManagerFactory.create(workManagerName, null, null, requestClass, max, min, null, null);
    }

    @Override
    protected WorkManager create(String workManagerName, int priority, int minThreadsConstraint, int maxThreadsConstraint) {
        return this.create(workManagerName, priority, -1, minThreadsConstraint, maxThreadsConstraint);
    }

    @Override
    protected WorkManager createResponseTime(String workManagerName, int responseTime, int minThreadsConstraint, int maxThreadsConstraint) {
        return this.create(workManagerName, -1, responseTime, minThreadsConstraint, maxThreadsConstraint);
    }

    protected static SelfTuningWorkManagerImpl create(String name, String appName, String moduleName, RequestClass p, MaxThreadsConstraint max, MinThreadsConstraint min, OverloadManager overload, StuckThreadManager stm) {
        return new SelfTuningWorkManagerImpl(name, appName, moduleName, p, max, min, overload, stm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartitionWorkManagersHolder getPartitionWorkManagerHolderForCurrentPartition() {
        ComponentInvocationContext componentInvocationContext = PartitionUtility.getCurrentComponentInvocationContext();
        if (componentInvocationContext.isGlobalRuntime()) {
            return null;
        }
        String partitionID = componentInvocationContext.getPartitionId();
        PartitionWorkManagersHolder partitionWorkManagersHolder = this.partitionWorkManagerMaps.get(partitionID);
        if (partitionWorkManagersHolder != null) {
            return partitionWorkManagersHolder;
        }
        ConcurrentHashMap<String, PartitionWorkManagersHolder> concurrentHashMap = this.partitionWorkManagerMaps;
        synchronized (concurrentHashMap) {
            partitionWorkManagersHolder = this.partitionWorkManagerMaps.get(partitionID);
            if (partitionWorkManagersHolder != null) {
                return partitionWorkManagersHolder;
            }
            PartitionWorkManagersHolder newPartitionWorkManagersHolder = this.createPartitionWorkManagerHolder();
            this.partitionWorkManagerMaps.put(partitionID, newPartitionWorkManagersHolder);
            return newPartitionWorkManagersHolder;
        }
    }

    @Override
    protected MonitorableMap<String, WorkManager> getDomainWorkManagersMap() {
        PartitionWorkManagersHolder partitionWorkManagersHolder = this.getPartitionWorkManagerHolderForCurrentPartition();
        if (partitionWorkManagersHolder == null) {
            return this.byName;
        }
        return partitionWorkManagersHolder.getWorkManagerMap();
    }

    static class PartitionWorkManagersHolder {
        private MonitorableMap<String, WorkManager> workManagerMap;
        private WorkManager system;
        private WorkManager defaultWM;
        private WorkManager rejector;

        PartitionWorkManagersHolder(MonitorableMap<String, WorkManager> workManagerMap, WorkManager system, WorkManager defaultWM, WorkManager rejector) {
            this.workManagerMap = workManagerMap;
            this.system = system;
            this.defaultWM = defaultWM;
            this.rejector = rejector;
        }

        public MonitorableMap<String, WorkManager> getWorkManagerMap() {
            return this.workManagerMap;
        }

        public WorkManager getSystem() {
            return this.system;
        }

        public WorkManager getDefault() {
            return this.defaultWM;
        }

        public WorkManager getRejector() {
            return this.rejector;
        }
    }
}

