/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.spi.ComponentRequest;
import weblogic.logging.Loggable;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.ComponentInvocationContextHolder;
import weblogic.work.ComponentWorkAdapter;
import weblogic.work.ConstraintFullQueueException;
import weblogic.work.Describable;
import weblogic.work.ExecuteThread;
import weblogic.work.FairShareRequestClass;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.MinThreadsConstraint;
import weblogic.work.OverloadManager;
import weblogic.work.PartitionFairShare;
import weblogic.work.PartitionUtility;
import weblogic.work.RequestClass;
import weblogic.work.RequestManager;
import weblogic.work.ServiceClassStatsSupport;
import weblogic.work.ServiceClassSupport;
import weblogic.work.StuckThreadManager;
import weblogic.work.ThreadUtility;
import weblogic.work.Work;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;
import weblogic.work.WorkManagerImpl;
import weblogic.work.WorkManagerLifecycleImpl;
import weblogic.work.WorkManagerLogger;

public class SelfTuningWorkManagerImpl
extends WorkManagerImpl
implements ComponentInvocationContextHolder {
    private static final DebugCategory DEBUG = Debug.getCategory("weblogic.workmanager");
    private static Logger debugLogger = new Logger(){

        @Override
        public boolean debugEnabled() {
            return DEBUG.isEnabled();
        }

        @Override
        public void log(String msg) {
            System.err.println("DEBUG: " + msg);
        }
    };
    private WorkManagerLifecycleImpl workManagerLifecycle;
    static OverloadManager SHARED_OVERLOAD_MANAGER;
    private final ServiceClassSupport requestClass;
    protected final MaxThreadsConstraint max;
    protected final MinThreadsConstraint min;
    private OverloadManager overload;
    private OverloadManager partitionOverload;
    private final StuckThreadManager stuckThreadManager;
    private AtomicLong acceptedCount = new AtomicLong();
    private AtomicLong completedCount = new AtomicLong();
    private final ComponentInvocationContext componentInvocationContext;
    private final String partitionName;
    private final boolean isGlobalDomain;

    static void initialize(int capacity) {
        SHARED_OVERLOAD_MANAGER = new OverloadManager("global overload manager");
        SHARED_OVERLOAD_MANAGER.setCapacity(capacity);
    }

    SelfTuningWorkManagerImpl(String name, String appName, String moduleName, RequestClass p, MaxThreadsConstraint max, MinThreadsConstraint min, OverloadManager overload, StuckThreadManager stm) {
        this(name, appName, moduleName, p, max, min, overload, null, null, stm, null);
    }

    SelfTuningWorkManagerImpl(String name, String appName, String moduleName, RequestClass p, MaxThreadsConstraint max, MinThreadsConstraint min, OverloadManager overload, OverloadManager partitionOverload, PartitionFairShare partitionFairShare, StuckThreadManager stm, ComponentInvocationContext componentInvocationContext) {
        this.wmName = name != null ? name.intern() : null;
        this.applicationName = appName;
        this.moduleName = moduleName;
        if (this.wmName != "weblogic.kernel.Default" && this.applicationName == null) {
            this.setInternal();
        }
        this.requestClass = p == null ? new FairShareRequestClass(name, appName, moduleName, partitionFairShare) : (ServiceClassSupport)p;
        if (this.isInternal()) {
            this.requestClass.setInternal(true);
        }
        this.max = max;
        this.min = min;
        if (min != null) {
            RequestManager.getInstance().register(min);
        }
        this.overload = overload;
        this.partitionOverload = partitionOverload;
        this.stuckThreadManager = stm;
        this.componentInvocationContext = componentInvocationContext;
        this.partitionName = componentInvocationContext == null ? null : componentInvocationContext.getPartitionName();
        this.isGlobalDomain = componentInvocationContext == null ? true : componentInvocationContext.isGlobalRuntime();
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getConfiguredThreadCount() {
        return -1;
    }

    @Override
    public void schedule(Runnable runnable) {
        this.scheduleInternal(runnable, false);
    }

    private boolean scheduleInternal(Runnable runnable, boolean fromScheduleIfBusy) {
        try {
            if ("direct" == this.wmName) {
                runnable.run();
                return true;
            }
            if (this.accept(runnable)) {
                WorkAdapter adapter = this.getWorkAdapter(runnable);
                if (fromScheduleIfBusy) {
                    RequestManager.getInstance().executeItWithRethrow(adapter);
                } else {
                    RequestManager.getInstance().executeIt(adapter);
                }
                return true;
            }
            if (this.workManagerLifecycle != null) {
                this.workManagerLifecycle.workCompleted();
            }
        }
        catch (ConstraintFullQueueException cfqe) {
            return false;
        }
        catch (RuntimeException re) {
            WorkManagerLogger.logScheduleFailed(this.wmName, re);
            throw re;
        }
        catch (OutOfMemoryError oome) {
            WorkManagerLogger.logScheduleFailed(this.wmName, oome);
            this.notifyOOME(oome);
            throw oome;
        }
        catch (Error e) {
            WorkManagerLogger.logScheduleFailed(this.wmName, e);
            throw e;
        }
        return false;
    }

    @Override
    public boolean executeIfIdle(Runnable runnable) {
        if ("direct" == this.wmName) {
            runnable.run();
            return true;
        }
        if (this.accept(runnable)) {
            return RequestManager.getInstance().executeIfIdle(this.getWorkAdapter(runnable));
        }
        return false;
    }

    @Override
    public boolean scheduleIfBusy(Runnable runnable) {
        ExecuteThread et = ThreadUtility.getCurrentThreadAsExecuteThread();
        if (et != null && this.min == null) {
            et.setLongRunningTask();
        }
        if (RequestManager.getInstance().isBusyForScheduleIfBusy() && this.scheduleInternal(runnable, true)) {
            return true;
        }
        if (et != null) {
            et.setHog(false);
            RequestManager.updateRequestClass((ServiceClassStatsSupport)((Object)et.getWorkManager().getRequestClass()), et);
        }
        return false;
    }

    private WorkAdapter getWorkAdapter(Runnable work) {
        WorkAdapter workAdapter;
        if (work instanceof WorkAdapter) {
            workAdapter = (WorkAdapter)work;
            if (!workAdapter.setScheduled()) {
                workAdapter = new WorkAdapterImpl((Runnable)workAdapter);
            }
        } else {
            workAdapter = new WorkAdapterImpl(work);
        }
        workAdapter.setWorkManager(this);
        return workAdapter;
    }

    @Override
    public int getQueueDepth() {
        return this.getPendingRequests();
    }

    @Override
    public boolean isThreadOwner(Thread th) {
        if (!(th instanceof ExecuteThread)) {
            return false;
        }
        ExecuteThread et = (ExecuteThread)th;
        return this == et.getWorkManager();
    }

    protected void notifyOOME(OutOfMemoryError oome) {
        try {
            Class<?> cls = Class.forName("weblogic.health.HealthMonitorService");
            Object hms = cls.newInstance();
            Class[] partypes = new Class[]{Class.forName("java.lang.Throwable")};
            Method meth = cls.getMethod("panic", partypes);
            Object[] args = new Object[]{oome};
            meth.invoke(hms, args);
        }
        catch (ClassNotFoundException cls) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw oome;
    }

    protected boolean accept(Runnable runnable) {
        String rejectionMessage;
        if (this.isInternal()) {
            return true;
        }
        if (!(runnable instanceof Work)) {
            return true;
        }
        OverloadManager rejectingOverloadManager = this.getRejectingOverloadManager();
        if (rejectingOverloadManager != null && (rejectionMessage = SelfTuningWorkManagerImpl.getOverloadMessage(rejectingOverloadManager)) != null) {
            return this.overload(rejectionMessage, runnable);
        }
        return true;
    }

    protected boolean overload(String rejectionMessage, Runnable runnable) {
        Runnable overloadAction = ((Work)runnable).overloadAction(rejectionMessage);
        if (overloadAction == null) {
            return true;
        }
        WorkManagerFactory.getInstance().getRejector().schedule(overloadAction);
        return false;
    }

    protected OverloadManager getRejectingOverloadManager() {
        if (this.overload != null && !this.overload.canAcceptMore()) {
            return this.overload;
        }
        if (!(this.partitionOverload == null || this.partitionOverload.canAcceptMore() || this.requestClass.getPendingRequestsCount() < this.partitionOverload.getCapacity() && this.partitionOverload.acceptRequestClass(this.requestClass))) {
            this.partitionOverload.incrementRejectedRequestsCounter();
            return this.partitionOverload;
        }
        if (SHARED_OVERLOAD_MANAGER.canAcceptMore()) {
            return null;
        }
        if (this.min != null && !this.min.isConstraintSatisfied()) {
            return null;
        }
        if (this.requestClass.getPendingRequestsCount() < SHARED_OVERLOAD_MANAGER.getCapacity() && SHARED_OVERLOAD_MANAGER.acceptRequestClass(this.requestClass)) {
            return null;
        }
        SHARED_OVERLOAD_MANAGER.incrementRejectedRequestsCounter();
        return SHARED_OVERLOAD_MANAGER;
    }

    static String getOverloadMessage(OverloadManager om) {
        Loggable loggable = WorkManagerLogger.logOverloadActionLoggable(om.getName(), om.getInProgress(), om.getCapacity());
        loggable.log();
        return loggable.getMessage();
    }

    String getCancelMessage() {
        Loggable loggable = WorkManagerLogger.logCancelAfterEnqueueLoggable(this.wmName, this.applicationName);
        loggable.log();
        return loggable.getMessage();
    }

    boolean isShutdown() {
        return this.workManagerLifecycle != null ? this.workManagerLifecycle.isShutdown() : false;
    }

    void accepted() {
        this.acceptedCount.getAndIncrement();
        if (!this.isInternal()) {
            SHARED_OVERLOAD_MANAGER.acceptWork();
            SHARED_OVERLOAD_MANAGER.incrementQueueDepth();
        }
        if (this.overload != null) {
            this.overload.acceptWork();
            this.overload.incrementQueueDepth();
        }
        if (this.partitionOverload != null) {
            this.partitionOverload.acceptWork();
            this.partitionOverload.incrementQueueDepth();
        }
        this.requestClass.incrementPendingRequestCount();
        if (this.workManagerLifecycle != null) {
            this.workManagerLifecycle.workAccepted();
        }
    }

    void started() {
        if (!this.isInternal()) {
            SHARED_OVERLOAD_MANAGER.decrementQueueDepth();
        }
        if (this.overload != null) {
            this.overload.decrementQueueDepth();
        }
        if (this.partitionOverload != null) {
            this.partitionOverload.decrementQueueDepth();
        }
        if (this.workManagerLifecycle != null) {
            this.workManagerLifecycle.workStarted();
        }
    }

    void increaseMaxThreadConstraintInProgress() {
        if (this.max != null) {
            this.max.acquire();
        }
    }

    void increaseMinThreadConstraintInProgress(boolean isStandbyThread) {
        if (this.min != null) {
            this.min.acquire(isStandbyThread);
        }
    }

    void stuck() {
        if (this.workManagerLifecycle != null) {
            this.workManagerLifecycle.workStuck();
        }
    }

    void unstuck() {
        if (this.workManagerLifecycle != null) {
            this.workManagerLifecycle.workUnstuck();
        }
    }

    void completed() {
        this.completedCount.getAndIncrement();
        if (!this.isInternal()) {
            SHARED_OVERLOAD_MANAGER.finishWork();
        }
        if (this.overload != null) {
            this.overload.finishWork();
        }
        if (this.partitionOverload != null) {
            this.partitionOverload.finishWork();
        }
        this.requestClass.decrementPendingRequestCount();
        if (this.min != null) {
            this.min.completed();
        }
        if (this.workManagerLifecycle != null) {
            this.workManagerLifecycle.workCompleted();
        }
    }

    void acquireMinMaxConstraint(boolean isStandbyThread) {
        this.increaseMinThreadConstraintInProgress(isStandbyThread);
        this.increaseMaxThreadConstraintInProgress();
    }

    void releaseMinMaxConstraint(boolean standbyThread) {
        if (this.min != null) {
            this.min.release(standbyThread);
        }
        if (this.max != null) {
            this.max.release();
        }
    }

    protected void setWorkManagerService(WorkManagerLifecycleImpl lifecycle) {
        this.workManagerLifecycle = lifecycle;
    }

    public WorkManagerLifecycleImpl getWorkManagerService() {
        return this.workManagerLifecycle;
    }

    final long getAcceptedCount() {
        return this.acceptedCount.get();
    }

    final long getCompletedCount() {
        return this.completedCount.get();
    }

    final OverloadManager getOverloadManager() {
        return this.overload;
    }

    public final void setCapacity(int capacity) {
        if (this.overload == null) {
            this.overload = new OverloadManager(this.wmName, capacity);
        } else {
            this.overload.setCapacity(capacity);
        }
    }

    public final RequestClass getRequestClass() {
        return this.requestClass;
    }

    public final MaxThreadsConstraint getMaxThreadsConstraint() {
        return this.max;
    }

    public final MinThreadsConstraint getMinThreadsConstraint() {
        return this.min;
    }

    protected final StuckThreadManager getStuckThreadManager() {
        return this.stuckThreadManager;
    }

    public int getPendingRequests() {
        int diff = (int)(this.getAcceptedCount() - this.getCompletedCount());
        return diff > 0 ? diff : 0;
    }

    public boolean isGlobalRuntime() {
        if (this.componentInvocationContext == null) {
            return true;
        }
        return this.componentInvocationContext.isGlobalRuntime();
    }

    @Override
    public ComponentInvocationContext getComponentInvocationContext() {
        return this.componentInvocationContext;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    void runWorkUnderContext(WorkAdapter workAdapter) throws Throwable {
        this.runWorkUnderContext(null, workAdapter);
    }

    void runWorkUnderContext(ExecuteThread invokingThread, WorkAdapter workAdapter) throws Throwable {
        ComponentInvocationContext workAdapterContext;
        ComponentInvocationContext context = this.componentInvocationContext;
        if (workAdapter instanceof ComponentRequest && (workAdapterContext = ((ComponentRequest)((Object)workAdapter)).getComponentInvocationContext()) != null) {
            context = workAdapterContext;
        }
        if (invokingThread != null) {
            invokingThread.setPreviousCIC(context);
        }
        try {
            PartitionUtility.runWorkUnderContext(workAdapter.getWork(), context);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public void cleanup() {
        if (!this.requestClass.isShared()) {
            this.requestClass.cleanup();
        }
        if (this.min != null && !this.min.isShared()) {
            this.min.cleanup();
        }
        if (this.max != null && !this.max.isShared()) {
            this.max.cleanup();
        }
    }

    static void setDebugLogger(Logger logger) {
        debugLogger = logger;
    }

    public static boolean debugEnabled() {
        return debugLogger.debugEnabled();
    }

    public static void debug(String msg) {
        debugLogger.log(msg);
    }

    public void dumpInformation(PrintWriter img) {
        if (img == null) {
            return;
        }
        img.println("--- WorkManager " + this.wmName + " for app " + this.applicationName + ", module " + this.moduleName + " ---");
        img.println("Requests accepted       : " + this.acceptedCount.get());
        img.println("Requests Completed      : " + this.completedCount.get());
    }

    @Override
    public String toString() {
        if (this.isGlobalDomain) {
            return this.applicationName + "@" + this.moduleName + "@" + this.wmName;
        }
        return this.partitionName + "@" + this.applicationName + "@" + this.moduleName + "@" + this.wmName;
    }

    public static interface Logger {
        public boolean debugEnabled();

        public void log(String var1);
    }

    private static final class WorkAdapterImpl
    extends ComponentWorkAdapter {
        private final Runnable runnable;

        private WorkAdapterImpl(Runnable runnable) {
            this.runnable = runnable;
            if (runnable instanceof ComponentRequest) {
                this.componentInvocationContext = ((ComponentRequest)((Object)runnable)).getComponentInvocationContext();
            }
        }

        private WorkAdapterImpl(Runnable runnable, ComponentInvocationContext cic) {
            this.runnable = runnable;
            this.componentInvocationContext = cic;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public Runnable overloadAction(String reason) {
            if (this.runnable instanceof Work) {
                Runnable overloadAction = ((Work)this.runnable).overloadAction(reason);
                if (overloadAction != null && this.componentInvocationContext != null) {
                    overloadAction = new WorkAdapterImpl(overloadAction, this.componentInvocationContext);
                }
                return overloadAction;
            }
            return null;
        }

        @Override
        public Runnable cancel(String reason) {
            if (this.runnable instanceof Work) {
                Runnable cancelAction = ((Work)this.runnable).cancel(reason);
                if (cancelAction != null && this.componentInvocationContext != null) {
                    cancelAction = new WorkAdapterImpl(cancelAction, this.componentInvocationContext);
                }
                return cancelAction;
            }
            return null;
        }

        @Override
        public void release() {
            if (this.runnable instanceof commonj.work.Work) {
                ((commonj.work.Work)this.runnable).release();
            } else {
                Runnable cancelTask = this.cancel("Work manager is being shut down");
                if (cancelTask != null) {
                    cancelTask.run();
                }
            }
        }

        @Override
        public String getDescription() {
            if (this.runnable instanceof Describable) {
                return ((Describable)((Object)this.runnable)).getDescription();
            }
            return null;
        }
    }
}

