/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.concurrent.atomic.AtomicInteger;
import weblogic.work.PartitionFairShare;
import weblogic.work.RequestClass;
import weblogic.work.RequestManager;
import weblogic.work.ServiceClassStatsSupport;

public abstract class ServiceClassSupport
extends ServiceClassStatsSupport
implements RequestClass,
Comparable {
    private long vtDeltaFirst;
    private long vtDeltaRepeat;
    private long myLast;
    private AtomicInteger pendingRequestCount = new AtomicInteger();
    private long vtIncrement;
    private int threadPriority = 5;
    private boolean internal;
    private final long requestQueueMaxValue;
    private boolean isShared;
    private long queueEmptiedCounter;
    protected PartitionFairShare partitionFairShare;

    public ServiceClassSupport(String n) {
        this(n, null);
    }

    public ServiceClassSupport(String n, PartitionFairShare partitionFairShare) {
        super(n);
        RequestManager.getInstance().register(this);
        this.requestQueueMaxValue = RequestManager.getInstance().getRequestQueueMaxValue();
        this.partitionFairShare = partitionFairShare;
    }

    @Override
    public void cleanup() {
        RequestManager.getInstance().deregister(this);
    }

    public ServiceClassSupport(String n, long d1, long dr) {
        this(n);
        this.vtDeltaFirst = d1;
        this.vtDeltaRepeat = dr;
    }

    @Override
    public final synchronized long getVirtualTimeIncrement(long present, long count) {
        long ahead;
        if (count != this.queueEmptiedCounter) {
            this.myLast = 0L;
            this.queueEmptiedCounter = count;
        }
        if ((ahead = this.myLast - present) < 0L) {
            this.myLast = present + this.vtDeltaFirst;
            return this.vtDeltaFirst;
        }
        this.myLast += this.vtDeltaRepeat;
        this.vtIncrement = ahead + this.vtDeltaRepeat;
        if (this.vtIncrement > this.requestQueueMaxValue - present) {
            this.vtIncrement = this.requestQueueMaxValue - present;
        }
        return this.vtIncrement;
    }

    protected final synchronized void setIncrements(long d1, long dr) {
        this.vtDeltaFirst = d1;
        this.vtDeltaRepeat = dr;
    }

    protected final long getDeltaFirst() {
        return this.vtDeltaFirst;
    }

    protected final long getDelta() {
        return this.vtDeltaRepeat;
    }

    protected long getIncrementForThreadPriorityCalculation() {
        return this.vtDeltaRepeat;
    }

    public final int compareTo(Object o) {
        ServiceClassSupport scs = (ServiceClassSupport)o;
        if (this.vtDeltaRepeat == scs.vtDeltaRepeat) {
            return scs.getPendingRequestsCount() - this.getPendingRequestsCount();
        }
        return (int)(this.vtDeltaRepeat - scs.vtDeltaRepeat);
    }

    @Override
    public final int getPendingRequestsCount() {
        return this.pendingRequestCount.get();
    }

    void incrementPendingRequestCount() {
        this.pendingRequestCount.getAndIncrement();
    }

    void decrementPendingRequestCount() {
        this.pendingRequestCount.getAndDecrement();
    }

    public final long getMyLast() {
        return this.myLast;
    }

    public final long getVirtualTimeIncrement() {
        return this.vtIncrement;
    }

    void setThreadPriority(int pri) {
        if (this.threadPriority == pri) {
            return;
        }
        this.threadPriority = pri;
    }

    @Override
    public int getThreadPriority() {
        return this.threadPriority;
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    void setInternal(boolean internal) {
        this.internal = internal;
    }

    void setShared(boolean shared) {
        this.isShared = shared;
    }

    boolean isShared() {
        return this.isShared;
    }

    @Override
    public PartitionFairShare getPartitionFairShare() {
        return this.partitionFairShare;
    }

    ServiceClassSupport createCopy(PartitionFairShare partitionFairShare) {
        return this;
    }
}

