/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.ArrayList;
import java.util.BitSet;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.ExecuteThread;
import weblogic.work.StuckThreadAction;
import weblogic.work.Work;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;
import weblogic.work.WorkManagerLogger;

final class StuckThreadManager {
    private static final DebugCategory debug = Debug.getCategory("weblogic.stuckthreadhandling");
    private final StuckThreadAction[] stuckThreadActions;
    private final String name;
    private BitSet stuckThreads = new BitSet();

    StuckThreadManager() {
        this.stuckThreadActions = null;
        this.name = "NO STUCK THREAD ACTIONS !";
    }

    StuckThreadManager(StuckThreadAction workManagerShutdown, StuckThreadAction adminMode, StuckThreadAction serverFailure) {
        StringBuffer sb = new StringBuffer();
        ArrayList<StuckThreadAction> list = new ArrayList<StuckThreadAction>();
        if (workManagerShutdown != null) {
            sb.append("WorkManagerShutdown: " + workManagerShutdown + "\n");
            list.add(workManagerShutdown);
        }
        if (adminMode != null) {
            sb.append("ApplicationAdminMode: " + adminMode + "\n");
            list.add(adminMode);
        }
        if (serverFailure != null) {
            sb.append("ServerFailureAction: " + serverFailure + "\n");
            list.add(serverFailure);
        }
        this.name = sb.toString();
        if (this.isDebugEnabled()) {
            this.debug("created StuckThreadManager");
        }
        this.stuckThreadActions = new StuckThreadAction[list.size()];
        list.toArray(this.stuckThreadActions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadUnStuck(int threadId) {
        if (this.stuckThreadActions == null) {
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug("Thread detected as unstuck !");
        }
        for (int cnt = 0; cnt < this.stuckThreadActions.length; ++cnt) {
            this.stuckThreadActions[cnt].threadUnStuck(threadId);
        }
        StuckThreadManager stuckThreadManager = this;
        synchronized (stuckThreadManager) {
            this.stuckThreads.clear(threadId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StuckThreadAction threadStuck(ExecuteThread thread, long elapsedTime, long maxTime) {
        if (this.stuckThreadActions == null) {
            return null;
        }
        int threadId = thread.id;
        StuckThreadAction stuck = null;
        if (this.isDebugEnabled()) {
            this.debug("Checking for stuck threads");
        }
        for (int cnt = 0; cnt < this.stuckThreadActions.length; ++cnt) {
            if (!this.stuckThreadActions[cnt].threadStuck(threadId, elapsedTime, maxTime)) continue;
            stuck = this.stuckThreadActions[cnt];
        }
        if (stuck != null) {
            boolean invokeCancel;
            StuckThreadManager stuckThreadManager = this;
            synchronized (stuckThreadManager) {
                invokeCancel = !this.stuckThreads.get(threadId);
                if (invokeCancel) {
                    this.stuckThreads.set(threadId);
                }
            }
            if (invokeCancel) {
                if (this.isDebugEnabled()) {
                    this.debug("Thread detected as stuck !");
                }
                this.cancelWork(thread);
            }
        }
        return stuck;
    }

    private void cancelWork(ExecuteThread thread) {
        WorkAdapter work = thread.getCurrentWork();
        if (work != null) {
            WorkManagerFactory.getInstance().getRejector().schedule(new CancelWorkTask(work));
        }
    }

    int getStuckThreadCount() {
        return this.stuckThreads.cardinality();
    }

    public String toString() {
        return this.name;
    }

    private boolean isDebugEnabled() {
        return debug.isEnabled();
    }

    private void debug(String str) {
        WorkManagerLogger.logDebug("[StuckThreadManager][" + this.name + "]" + str);
    }

    static class CancelWorkTask
    implements Runnable {
        private final Work work;

        CancelWorkTask(Work work) {
            this.work = work;
        }

        @Override
        public void run() {
            Runnable cancelTask = this.work.cancel("Work cancelled due to stuck thread");
            if (cancelTask != null) {
                cancelTask.run();
            }
        }
    }
}

