/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import weblogic.logging.Loggable;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.StackTraceUtils;
import weblogic.work.RequestManager;
import weblogic.work.SelfTuningWorkManagerImpl;
import weblogic.work.ShutdownCallback;
import weblogic.work.Work;
import weblogic.work.WorkFilter;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;
import weblogic.work.WorkManagerLifecycle;
import weblogic.work.WorkManagerLogger;

public class WorkManagerLifecycleImpl
implements WorkManagerLifecycle,
WorkManager {
    private static final DebugCategory debugWMService = Debug.getCategory("weblogic.workmanagerservice");
    protected int state = 3;
    protected int workCount;
    protected final WorkManager delegate;
    protected ShutdownCallback callback;
    protected boolean internal;
    protected int stuckThreadCount;

    public WorkManagerLifecycleImpl(WorkManager workManager) {
        this.delegate = workManager;
        if (workManager instanceof SelfTuningWorkManagerImpl) {
            ((SelfTuningWorkManagerImpl)workManager).setWorkManagerService(this);
        }
        if (WorkManagerLifecycleImpl.debugEnabled()) {
            WorkManagerLifecycleImpl.debug("-- wmlifecycle created - " + this);
        }
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getApplicationName() {
        return this.delegate.getApplicationName();
    }

    @Override
    public String getModuleName() {
        return this.delegate.getModuleName();
    }

    @Override
    public int getType() {
        return this.delegate.getType();
    }

    @Override
    public int getConfiguredThreadCount() {
        return this.delegate.getConfiguredThreadCount();
    }

    @Override
    public synchronized int getState() {
        return this.state;
    }

    @Override
    public synchronized void start() {
        this.state = 1;
        this.resetCallBack();
        if (WorkManagerLifecycleImpl.debugEnabled()) {
            WorkManagerLifecycleImpl.debug("-- wmlifecycle - " + this + " started");
        }
    }

    private void resetCallBack() {
        this.callback = null;
    }

    @Override
    public boolean isShutdown() {
        if (WorkManagerLifecycleImpl.debugEnabled()) {
            WorkManagerLifecycleImpl.debug("-- wmlifecycle - " + this + " is shutdown : " + (this.state == 3));
        }
        return this.state == 3;
    }

    @Override
    public synchronized void shutdown(ShutdownCallback callback) {
        if (this.internal || this.state == 3 || this.state == 2) {
            if (callback != null) {
                callback.completed();
            }
            return;
        }
        if (WorkManagerLifecycleImpl.debugEnabled()) {
            WorkManagerLifecycleImpl.debug("-- wmlifecycle - " + this + " shutdown with callback " + callback + "\nstack trace:\n" + StackTraceUtils.throwable2StackTrace(null));
        }
        this.callback = callback;
        if (WorkManagerLifecycleImpl.debugEnabled()) {
            WorkManagerLifecycleImpl.debug("-- wmlifecycle - " + this + " has no pending txn. commencing shutdown ...");
        }
        this.state = 3;
        this.releaseExecutingRequests();
        if (this.workPending()) {
            return;
        }
        if (WorkManagerLifecycleImpl.debugEnabled()) {
            WorkManagerLifecycleImpl.debug("-- wmlifecycle - " + this + " has no pending work and no pending txn. Invoking callback");
        }
        if (callback != null) {
            callback.completed();
        }
        this.callback = null;
    }

    protected void releaseExecutingRequests() {
        RequestManager.getInstance().releaseExecutingRequestFor(this.delegate);
    }

    public void releaseExecutingRequests(WorkFilter filter) {
        RequestManager.getInstance().releaseExecutingRequestFor(this.delegate, filter);
    }

    @Override
    public void forceShutdown() {
        if (WorkManagerLifecycleImpl.debugEnabled()) {
            WorkManagerLifecycleImpl.debug("-- wmlifecycle - " + this + " force shutdown with callback " + this.callback + "\nstack trace:\n" + StackTraceUtils.throwable2StackTrace(null));
        }
        this.state = 3;
    }

    @Override
    public void schedule(Runnable runnable) {
        if (this.permitSchedule(runnable)) {
            try {
                this.delegate.schedule(runnable);
            }
            finally {
                if ("direct" == this.delegate.getName() || this.getType() == 2) {
                    this.workCompleted();
                }
            }
        } else {
            this.cancelWork(runnable);
        }
    }

    String getCancelMessage() {
        Loggable loggable = WorkManagerLogger.logCancelBeforeEnqueueLoggable(this.getName(), this.getApplicationName());
        loggable.log();
        return loggable.getMessage();
    }

    @Override
    public boolean executeIfIdle(Runnable runnable) {
        boolean executed = false;
        if (this.permitSchedule(runnable)) {
            try {
                executed = this.delegate.executeIfIdle(runnable);
            }
            finally {
                if (!executed || "direct" == this.delegate.getName() || this.getType() == 2) {
                    this.workCompleted();
                }
            }
        }
        return executed;
    }

    @Override
    public boolean scheduleIfBusy(Runnable runnable) {
        if (this.permitSchedule(runnable)) {
            boolean isScheduled = false;
            try {
                isScheduled = this.delegate.scheduleIfBusy(runnable);
            }
            finally {
                if (!isScheduled || "direct" == this.delegate.getName() || this.getType() == 2) {
                    this.workCompleted();
                }
            }
            return isScheduled;
        }
        this.cancelWork(runnable);
        return false;
    }

    private void cancelWork(Runnable runnable) {
        Debug.assertion(runnable instanceof Work, "Only work instances can be submitted to WorkManagerService");
        Runnable cancel = ((Work)runnable).cancel(this.getCancelMessage());
        Debug.assertion(cancel != null, "cancel task cannot be null");
        WorkManagerFactory.getInstance().getRejector().schedule(cancel);
    }

    @Override
    public int getQueueDepth() {
        return this.workCount;
    }

    @Override
    public void setInternal() {
        this.internal = true;
        this.delegate.setInternal();
        if (WorkManagerLifecycleImpl.debugEnabled()) {
            WorkManagerLifecycleImpl.debug("-- wmservice - " + this + " marked internal");
        }
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public boolean isThreadOwner(Thread th) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean permitSchedule(Runnable runnable) {
        if (this.internal) {
            return true;
        }
        boolean allowWork = false;
        WorkManagerLifecycleImpl workManagerLifecycleImpl = this;
        synchronized (workManagerLifecycleImpl) {
            if (this.state == 1 || !(runnable instanceof Work)) {
                ++this.workCount;
                allowWork = true;
            }
        }
        if (allowWork) {
            return true;
        }
        if (WorkManagerLifecycleImpl.debugEnabled()) {
            WorkManagerLifecycleImpl.debug("-- wmlifecycle - " + this + " is shutdown");
        }
        return false;
    }

    public void workAccepted() {
    }

    public void workStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workStuck() {
        boolean pendingWork;
        if (this.internal) {
            return;
        }
        WorkManagerLifecycleImpl workManagerLifecycleImpl = this;
        synchronized (workManagerLifecycleImpl) {
            ++this.stuckThreadCount;
            if (this.state != 3) {
                return;
            }
            pendingWork = this.workPending();
        }
        if (!pendingWork) {
            this.invokeCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workUnstuck() {
        if (this.internal) {
            return;
        }
        WorkManagerLifecycleImpl workManagerLifecycleImpl = this;
        synchronized (workManagerLifecycleImpl) {
            --this.stuckThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeCallback() {
        try {
            ShutdownCallback temp;
            if (this.callback == null) {
                return;
            }
            WorkManagerLifecycleImpl workManagerLifecycleImpl = this;
            synchronized (workManagerLifecycleImpl) {
                if (this.callback == null) {
                    return;
                }
                temp = this.callback;
                this.callback = null;
            }
            if (WorkManagerLifecycleImpl.debugEnabled()) {
                WorkManagerLifecycleImpl.debug("-- wmlifecycle - " + this + " has no pending work. Invoking callback");
            }
            temp.completed();
        }
        catch (Throwable th) {
            WorkManagerLogger.logShutdownCallbackFailed(th);
        }
    }

    protected boolean workPending() {
        return this.workCount - this.stuckThreadCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workCompleted() {
        boolean pendingWork;
        if (this.internal) {
            return;
        }
        WorkManagerLifecycleImpl workManagerLifecycleImpl = this;
        synchronized (workManagerLifecycleImpl) {
            --this.workCount;
            if (this.state != 3) {
                return;
            }
            pendingWork = this.workPending();
        }
        if (pendingWork) {
            if (WorkManagerLifecycleImpl.debugEnabled()) {
                WorkManagerLifecycleImpl.debug("-- wmlifecycle - " + this + " is shutdown and waiting for " + this.workCount + " to finish");
            }
        } else {
            this.invokeCallback();
        }
    }

    public String toString() {
        return super.toString() + "[" + this.delegate.toString() + "]";
    }

    protected static boolean debugEnabled() {
        return debugWMService.isEnabled();
    }

    protected static void debug(String str) {
        WorkManagerLogger.logDebug(str);
    }
}

