/*
 * Decompiled with CFR 0.152.
 */
package weblogic.workarea;

import java.io.IOException;
import java.io.Serializable;
import weblogic.workarea.AsciiWorkContext;
import weblogic.workarea.LongWorkContext;
import weblogic.workarea.SerializableWorkContext;
import weblogic.workarea.StringWorkContext;
import weblogic.workarea.WorkContext;

public class PrimitiveContextFactory {
    public static String createEncodedKey(String key) {
        StringBuffer code = new StringBuffer();
        for (int hash = key.hashCode(); hash != 0; hash >>>= 6) {
            code.append((char)(59 + (hash & 0x3F)));
        }
        return code.toString();
    }

    public static WorkContext create(String ctx) {
        return new StringWorkContext(ctx);
    }

    public static WorkContext create(long ctx) {
        return new LongWorkContext(ctx);
    }

    public static WorkContext createASCII(String ctx) {
        return new AsciiWorkContext(ctx);
    }

    public static WorkContext create(Serializable ctx) throws IOException {
        return new SerializableWorkContext(ctx);
    }

    public static WorkContext createMutable(Serializable ctx) throws IOException {
        return new SerializableWorkContext(ctx, true);
    }
}

