/*
 * Decompiled with CFR 0.152.
 */
package weblogic.workarea;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import weblogic.diagnostics.debug.DebugLogger;

public class WorkContextFilter {
    static final String DISABLE_PROPAGATION_MODES_PROPERTY = "weblogic.workarea.disablePropagationModes";
    static final String DISABLE_CONTEXT_NAMES_PROPERTY = "weblogic.workarea.disableContextNames";
    static final List DISABLE_CONTEXT_NAMES = new ArrayList();
    static int propagationModeFilterMask = -1;
    private static final DebugLogger debugWorkContext = DebugLogger.getDebugLogger("DebugWorkContext");

    public static void initialize() {
        String disableContextNames = WorkContextFilter.initProperty(DISABLE_CONTEXT_NAMES_PROPERTY, null);
        String disablePropagationModes = WorkContextFilter.initProperty(DISABLE_PROPAGATION_MODES_PROPERTY, null);
        if (disableContextNames != null && disablePropagationModes != null) {
            WorkContextFilter.updateDisableContextNamesList(disableContextNames);
            WorkContextFilter.updatePropagationModeFilterMask(disablePropagationModes);
        }
    }

    private static String initProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }

    private static void updateDisableContextNamesList(String disableContextNames) {
        if (disableContextNames != null) {
            disableContextNames = WorkContextFilter.stripEnclosingQuotes(disableContextNames.trim());
            StringTokenizer st = new StringTokenizer(disableContextNames, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (debugWorkContext.isDebugEnabled()) {
                    debugWorkContext.debug("Disabling propagation of contexts with name " + token);
                }
                DISABLE_CONTEXT_NAMES.add(token);
            }
        }
    }

    private static void updatePropagationModeFilterMask(String disablePropagationModes) {
        if (disablePropagationModes != null) {
            disablePropagationModes = WorkContextFilter.stripEnclosingQuotes(disablePropagationModes.trim());
            StringTokenizer st = new StringTokenizer(disablePropagationModes, ",");
            while (st.hasMoreTokens()) {
                String modeToDisable = st.nextToken().trim();
                int propagationModeToFilter = WorkContextFilter.getPropagationModeFromName(modeToDisable);
                if (propagationModeToFilter == 0) continue;
                if (debugWorkContext.isDebugEnabled()) {
                    debugWorkContext.debug("Disabling propagation of contexts with propagation mode " + modeToDisable);
                }
                propagationModeFilterMask &= ~propagationModeToFilter;
            }
        }
    }

    private static String stripEnclosingQuotes(String string) {
        return string.replaceAll("^([\"'])(.*)\\1$", "$2");
    }

    static int getPropagationModeFromName(String propagationModeName) {
        if ("LOCAL".equals(propagationModeName)) {
            return 1;
        }
        if ("WORK".equals(propagationModeName)) {
            return 2;
        }
        if ("RMI".equals(propagationModeName)) {
            return 4;
        }
        if ("TRANSACTION".equals(propagationModeName)) {
            return 8;
        }
        if ("JMS_QUEUE".equals(propagationModeName)) {
            return 16;
        }
        if ("JMS_TOPIC".equals(propagationModeName)) {
            return 32;
        }
        if ("SOAP".equals(propagationModeName)) {
            return 64;
        }
        if ("MIME_HEADER".equals(propagationModeName)) {
            return 128;
        }
        if ("ONEWAY".equals(propagationModeName)) {
            return 256;
        }
        if ("GLOBAL".equals(propagationModeName)) {
            return 212;
        }
        if ("DEFAULT".equals(propagationModeName)) {
            return 212;
        }
        return 0;
    }

    static int getFilteredPropagationMode(String contextName, int propagationMode) {
        if (!DISABLE_CONTEXT_NAMES.isEmpty() && DISABLE_CONTEXT_NAMES.contains(contextName)) {
            return propagationMode & propagationModeFilterMask;
        }
        return propagationMode;
    }
}

